import java.awt.BorderLayout;
import java.awt.EventQueue;

import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.border.EmptyBorder;
import javax.swing.JList;
import javax.swing.JScrollPane;
import javax.swing.JButton;
import javax.swing.JMenuBar;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;

import java.awt.event.ActionListener;
import java.awt.event.ActionEvent;

public class UsoBusqueda extends JFrame {

	private JPanel contentPane;
	private Lista listax=new Lista();

	/**
	 * Launch the application.
	 */
	public static void main(String[] args) {
		EventQueue.invokeLater(new Runnable() {
			public void run() {
				try {
					UsoBusqueda frame = new UsoBusqueda();
					frame.setVisible(true);
				} catch (Exception e) {
					e.printStackTrace();
				}
			}
		});
	}

	/**
	 * Create the frame.
	 */
	public UsoBusqueda() {
		setTitle("BUSQUEDAS");
		setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
		setBounds(100, 100, 382, 437);
		
		JMenuBar menuBar = new JMenuBar();
		setJMenuBar(menuBar);
		
		JMenu mnArchivo = new JMenu("Archivo");
		menuBar.add(mnArchivo);
		
		JMenuItem mntmGuarda = new JMenuItem("Guardar");
		mnArchivo.add(mntmGuarda);
		
		JMenuItem mntmAbrir = new JMenuItem("Abrir");
		mnArchivo.add(mntmAbrir);
		
		JMenu mnBusquedas = new JMenu("Busquedas");
		menuBar.add(mnBusquedas);
		
		JMenuItem mntmSecuencialDesordenado = new JMenuItem("Secuencial Desordenado");
		mnBusquedas.add(mntmSecuencialDesordenado);
		
		JMenuItem mntmSecuencialOrdenado = new JMenuItem("Secuencial Ordenado");
		mnBusquedas.add(mntmSecuencialOrdenado);
		
		JMenuItem mntmBinaria = new JMenuItem("Binaria");
		mnBusquedas.add(mntmBinaria);
		contentPane = new JPanel();
		contentPane.setBorder(new EmptyBorder(5, 5, 5, 5));
		setContentPane(contentPane);
		contentPane.setLayout(null);
		
		JScrollPane scrollPane = new JScrollPane();
		scrollPane.setBounds(27, 35, 132, 334);
		contentPane.add(scrollPane);
		
		JList<Alumno> lstAlumnos = new JList<Alumno>();
		scrollPane.setViewportView(lstAlumnos);
		
		JButton btnAgregar = new JButton("Agregar");
		btnAgregar.setBounds(188, 38, 89, 23);
		contentPane.add(btnAgregar);
		
		JButton btnEliminar = new JButton("Eliminar");
		btnEliminar.setBounds(188, 80, 89, 23);
		contentPane.add(btnEliminar);
		
		JButton btnOrdena = new JButton("Ordena");
		btnOrdena.setBounds(188, 125, 89, 23);
		contentPane.add(btnOrdena);
		//Acciones
		btnAgregar.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent arg0) {
				try{
					Alumno alu=new Alumno();
					if (alu.pedirDatos()){
						listax.lista.add(alu);
						lstAlumnos.setModel(listax.mostrar());
					} else alu=null;
				} catch (Exception ex){
					JOptionPane.showMessageDialog(null,"Error al agregar");
				}
			}
		});
		btnEliminar.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent arg0) {
				try{
					int index=lstAlumnos.getSelectedIndex();
					if (index>=0){
						listax.lista.remove(index);
						lstAlumnos.setModel(listax.mostrar());
					}
				} catch (Exception ex){
					JOptionPane.showMessageDialog(null,"Error al eliminar");
				}
			}
		});
		mntmSecuencialDesordenado.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent arg0) {
				try{
					long noctrl=Long.parseLong(
					JOptionPane.showInputDialog("No. control a buscar:"));
					Alumno alux=listax.busquedaSecuencialDesOrd(noctrl);
					if (alux!=null){
						alux.mostrarDatos();
					} else 
				JOptionPane.showMessageDialog(null,"Alumno no existe");
				} catch (Exception ex){
				JOptionPane.showMessageDialog(null,"Error al buscar");
				}
			}
		});
		mntmGuarda.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent arg0) {
				try{
					listax.guardar();
			JOptionPane.showMessageDialog(null,"Archivo guardado");
				} catch (Exception ex){
					JOptionPane.showMessageDialog(null,"Error al guardar");
				}
			}
		});
		mntmAbrir.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent arg0) {
				try{
					listax.abrir();
					lstAlumnos.setModel(listax.mostrar());
				} catch (Exception ex){
					JOptionPane.showMessageDialog(null,"Error al abrir");
				}
			}
		});
		btnOrdena.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent arg0) {
				try{
					listax.ordenarLista();
					lstAlumnos.setModel(listax.mostrar());
				} catch (Exception ex){
					JOptionPane.showMessageDialog(null,"Error al ordenar"+ex.getMessage());
				}
			}
		});
		mntmSecuencialOrdenado.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent arg0) {
				try{
					long noctrl=Long.parseLong(
					JOptionPane.showInputDialog("No. control a buscar:"));
					Alumno alux=listax.busquedaSecuencialOrd(noctrl);
					if (alux!=null){
						alux.mostrarDatos();
					} else 
				JOptionPane.showMessageDialog(null,"Alumno no existe");
				} catch (Exception ex){
				JOptionPane.showMessageDialog(null,"Error al buscar");
				}
			}
		});
		mntmBinaria.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent e) {
				try{
					long noctrl=Long.parseLong(
					JOptionPane.showInputDialog("No. control a buscar:"));
					Alumno alux=listax.busquedaBinaria(noctrl);
					if (alux!=null){
						alux.mostrarDatos();
					} else 
				JOptionPane.showMessageDialog(null,"Alumno no existe");
				} catch (Exception ex){
				JOptionPane.showMessageDialog(null,"Error al buscar");
				}
			}
		});
	}
}
