import java.util.*;
import java.io.*;
import javax.swing.*;
import javax.swing.filechooser.FileNameExtensionFilter;
public class Lista {
	 public ArrayList <Alumno> lista=new ArrayList <Alumno>() ;
	//Metodo para convertir lista a modelo
	public DefaultListModel<Alumno> mostrar(){
		DefaultListModel<Alumno> aux=
				new DefaultListModel<Alumno>();
		for (Alumno alux:lista){
			   aux.addElement(alux);
		}
		return aux;
	}
	//Metodos para guardar y abrir achivos de objetos
	public void guardar() throws Exception
	{
		JFileChooser fc=new JFileChooser();
		fc.setDialogTitle("Escribe archivo a guardar:");
		//Para mostrar solo archivos de objetos
		 FileNameExtensionFilter filtro=
		new FileNameExtensionFilter("OBJETOS","obj");
		 fc.setFileFilter(filtro);
		int respuesta=fc.showSaveDialog(null);
		if (respuesta==JFileChooser.APPROVE_OPTION){
			File archivo=fc.getSelectedFile();
			FileOutputStream fos=new FileOutputStream(archivo);
			//Crear flujo de salida para escritura de objetos
			ObjectOutputStream oos=new ObjectOutputStream(fos);
			for (Alumno alux:lista){
				oos.writeObject(alux);
			}
			oos.close();
		}
	}
	public void abrir() throws Exception
	{
		JFileChooser fc=new JFileChooser();
		fc.setDialogTitle("Selecciona archivo a abrir:");
		//Para mostrar solo archivos de objetos
		FileNameExtensionFilter filtro=
				new FileNameExtensionFilter("OBJETOS","obj");
		fc.setFileFilter(filtro);
		int respuesta=fc.showOpenDialog(null);
		if (respuesta==JFileChooser.APPROVE_OPTION){
			File archivo=fc.getSelectedFile();
			FileInputStream fos=new FileInputStream(archivo);
			//Crear flujo de entrad para lectura de objetos
			ObjectInputStream ois=new ObjectInputStream(fos);
			try{
	           //Limpiar lista
				lista.clear();Alumno alux;
				while (true){
					alux=(Alumno) ois.readObject();
					lista.add(alux);
				}
			} catch (EOFException ex){
				ois.close();
			}
	}	
}

	//Metodo para busqueda secuencial
	public Alumno busquedaSecuencialDesOrd(long clave){
		Alumno alux=null;
		//Recorrer casilla por casilla y compara si el elemento 
		//coincide con la clave
		for (Alumno x:lista){
			if (x.getNoctrl()==clave) {
				//Encuentra el no. de control buscado
				alux=x;break;
			}
		}
		return alux;
	}
	//Metodo ordenar lista
	public void ordenarLista(){
		//Redefine el metodo compare para ordenar por numero de control
		lista.sort(new Comparator<Alumno>(){
			@Override
			public int compare(Alumno arg0, Alumno arg1) {
				if (arg0.getNoctrl()==arg1.getNoctrl()) return 0;
				else if (arg0.getNoctrl()>arg1.getNoctrl()) return 1;
				else return -1;
			}});
	}
	//Metodo para busqueda secuencial Ordenado
	public Alumno busquedaSecuencialOrd(long clave){
		Alumno alux=null;int pos=-1;
		//Recorrer casilla por casilla y compara si el elemento 
		//coincide con la clave
		int i=0;
		for (Alumno x:lista){
			if (x.getNoctrl()>=clave) {
				//Encuentra el no. de control buscado
				pos=i;break;
			}
			i++;
		}
		if (pos>=0)
			if (lista.get(pos).getNoctrl()==clave) alux=lista.get(pos);
		return alux;
	}
	
	//Metodo para Busqueda Binaria
	public Alumno busquedaBinaria(long clave){
		int mitad,izq,der;
		izq=0;
		der=lista.size()-1;
		Alumno alux=null;
		while (izq<=der){
			mitad=(izq+der)/2;
			if (lista.get(mitad).getNoctrl()==clave){
				alux=lista.get(mitad);break;
			} else if (lista.get(mitad).getNoctrl()>clave) {
				//Debe de estar del lado izquierdo
				der=mitad-1;
			} else {
				//Esta por el lado derecho
				izq=mitad+1;
			}
		}
		return alux;
	}
}
