import java.awt.BorderLayout;
import java.awt.EventQueue;
import javax.swing.border.EmptyBorder;
import java.awt.event.ActionListener;
import java.awt.event.ActionEvent;
import javax.swing.*;
import static javax.swing.JOptionPane.*;
public class UsaOrdenaExterno extends JFrame {
	private JPanel contentPane;
	private DefaultListModel<Double> listaModelo=
			new DefaultListModel<Double>();
	private OrdenamientoExterno ordena=new OrdenamientoExterno();

	/**
	 * Launch the application.
	 */
	public static void main(String[] args) {
		EventQueue.invokeLater(new Runnable() {
			public void run() {
				try {
					UsaOrdenaExterno frame = new UsaOrdenaExterno();
					frame.setVisible(true);
				} catch (Exception e) {
					e.printStackTrace();
				}
			}
		});
	}

	/**
	 * Create the frame.
	 */
	public UsaOrdenaExterno() {
		setTitle("Ordenamiento Externo");
		setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
		setBounds(100, 300, 450, 500);
		
		JMenuBar menuBar = new JMenuBar();
		setJMenuBar(menuBar);
		
		JMenu mnArchivo = new JMenu("Archivo");
		menuBar.add(mnArchivo);
		
		JMenuItem mntmAbrir = new JMenuItem("Abrir");
		mnArchivo.add(mntmAbrir);
		
		JMenuItem mntmGuardar = new JMenuItem("Guardar");
		mnArchivo.add(mntmGuardar);
		
		JMenu mnMetodos = new JMenu("Metodos");
		menuBar.add(mnMetodos);
		
		JMenuItem mntmIntercalacion = new JMenuItem("Intercalacion");
		mnMetodos.add(mntmIntercalacion);
		
		JMenuItem mntmNewMenuItem = new JMenuItem("Mezcla Directa");
		mnMetodos.add(mntmNewMenuItem);
		
		JMenuItem mntmNewMenuItem2 = new JMenuItem("Mezcla Equilibrada");
		mnMetodos.add(mntmNewMenuItem2);
		
		contentPane = new JPanel();
		contentPane.setBorder(new EmptyBorder(5, 5, 5, 5));
		setContentPane(contentPane);
		contentPane.setLayout(null);
		
		JScrollPane scrollPane = new JScrollPane();
		scrollPane.setBounds(21, 23, 112, 362);
		contentPane.add(scrollPane);
		
		JList<Double> listax = new JList<Double>();
		scrollPane.setViewportView(listax);
		
		JButton btnAgregar = new JButton("Agregar");
		btnAgregar.setBounds(150, 25, 89, 23);
		contentPane.add(btnAgregar);
		
		JButton btnEliminar = new JButton("Eliminar");
		btnEliminar.setBounds(150, 59, 89, 23);
		contentPane.add(btnEliminar);
		
		JButton btnLimpiar = new JButton("Limpiar");
		btnLimpiar.setBounds(150, 93, 89, 23);
		contentPane.add(btnLimpiar);
		//Acciones
		btnAgregar.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent arg0) {
				try{
					double x=
					Double.parseDouble(showInputDialog("Teclea el valor"));
					listaModelo.addElement(x);
					listax.setModel(listaModelo);
				} catch (Exception ex){
				showMessageDialog(null,"No se pudo agregar");
				}
			}
		});
		btnEliminar.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent arg0) {
				try{
					int i=listax.getSelectedIndex(); //Obtiene indice seleccionado
					if (i>=0){
					listaModelo=(DefaultListModel<Double>) listax.getModel();
					//Elimina elemento seleccionado
					listaModelo.removeElementAt(i);
					listax.setModel(listaModelo); 
					}
				} catch (Exception ex){
				showMessageDialog(null,"No se pudo eliminar");
				}
			}
		});
		btnLimpiar.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent arg0) {
				try{
					listaModelo=(DefaultListModel<Double>) listax.getModel();
					listaModelo.clear();
					listax.setModel(listaModelo);
				} catch (Exception ex){
				showMessageDialog(null,"No se pudo Limpiar");
				}
			}
		});
		mntmAbrir.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent arg0) {
				try{
					//Establece modelo a partir del archivo
					listax.setModel(ordena.abrir());
				} catch (Exception ex){
					showMessageDialog(null,"No se pudo abrir archivo");
				}
			}
		});
		mntmGuardar.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent e) {
				try{
					ordena.guardar((DefaultListModel<Double>) listax.getModel());
				} catch (Exception ex){
					showMessageDialog(null,"No se pudo guardar archivo");
				}
			}
		});
		mntmIntercalacion.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent arg0) {
				ordena.intercalacion();
				showMessageDialog(null,"Intercalacin exitosa");
			}
		});
		mntmNewMenuItem.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent arg0) {
				ordena.mezclaDirecta();
				showMessageDialog(null,"Ordenacion exitosa");
			}
		});
		mntmNewMenuItem2.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent arg0) {
				ordena.mezclaEquilibrada();
				showMessageDialog(null,"Ordenacion exitosa");
			}
		});
	}
}
