package itz;
//Clase que representa un grafo implementado con una matriz de adyacencia
public class GrafoMatriz {
	//Atributos
	private int n; //Reprenta la ultima casilla ocupada en la lista de vertices
	private Vertice lstVertices[];
	private int matrizAdy[][];
	//Constructor
	public GrafoMatriz(int max) {
		//Dimensionar la lista de vertices y la matriz
		lstVertices=new Vertice[max];
		matrizAdy=new int[max][max];
		n=-1; //La lista de vertices esta vacia
		inicializar(0);
	}
	public void inicializar(int valorx) {
		for (int i=0;i<matrizAdy.length;i++)
			for (int j=0;j<matrizAdy[0].length;j++)
				if (i==j) matrizAdy[i][j]=0;
				else matrizAdy[i][j]=999999999;
	}
	public void mostrarMatriz() {
		for (int i=0;i<matrizAdy.length;i++) {
			for (int j=0;j<matrizAdy[0].length;j++)
				System.out.printf("%10d", matrizAdy[i][j]);
			System.out.println();
		}
	}
	public void mostrarVertices() {
		for (int i=0;i<=n;i++) 
			System.out.println(lstVertices[i]);
	    System.out.println();
	}
	//Operaciones basicas
	public boolean existeVertice(Vertice vx) {
		for (int i=0;i<=n;i++)
			if (lstVertices[i].equals(vx)) return true;
		return false;
	}
	public int numeroVertice(Vertice vx) {
		for (int i=0;i<=n;i++)
			if (lstVertices[i].equals(vx)) return lstVertices[i].getNumero();
		return -1; //Vertice no existe
	}
	public void agregarVertice(Vertice vx) {
		if (!existeVertice(vx)) {
			n=n+1;
			lstVertices[n]=vx;
			vx.setNumero(n);
		} else System.out.println("Vertice ya existe en grafo");
	}
	public void agregarArco(String v,String u,boolean dirigido,int peso) {
		int nv,nu;
		nv=numeroVertice(new Vertice(v));
		nu=numeroVertice(new Vertice(u));
		if (nv>=0 && nu>=0) {
			matrizAdy[nv][nu]=peso; //Se asigna un arco con un peso especifico
			if (!dirigido) matrizAdy[nu][nv]=peso; 	
		} else System.out.println("Uno de los vertices no existe en el grafo");
	}
}
