import java.awt.BorderLayout;
import java.awt.EventQueue;

import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.border.EmptyBorder;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JButton;
import java.awt.event.ActionListener;
import java.awt.event.ActionEvent;

public class UsaListaHash extends JFrame {

	private JPanel contentPane;
	private ListaHash listahash=new ListaHash();
	private DatosAlumno datos;

	/**
	 * Launch the application.
	 */
	public static void main(String[] args) {
		EventQueue.invokeLater(new Runnable() {
			public void run() {
				try {
					UsaListaHash frame = new UsaListaHash();
					frame.setVisible(true);
				} catch (Exception e) {
					e.printStackTrace();
				}
			}
		});
	}

	/**
	 * Create the frame.
	 */
	public UsaListaHash() {
		setTitle("Busqueda Hash");
		setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
		setBounds(100, 100, 302, 439);
		contentPane = new JPanel();
		contentPane.setBorder(new EmptyBorder(5, 5, 5, 5));
		setContentPane(contentPane);
		contentPane.setLayout(null);
		
		JScrollPane scrollPane = new JScrollPane();
		scrollPane.setBounds(10, 11, 148, 378);
		contentPane.add(scrollPane);
		
		JList<Alumno> lstAlumnos = new JList<Alumno>();
		scrollPane.setViewportView(lstAlumnos);
		
		JButton btnAgregar = new JButton("Agregar");
		btnAgregar.setBounds(187, 11, 89, 23);
		contentPane.add(btnAgregar);
		
		JButton btnEliminar = new JButton("Eliminar");
		btnEliminar.setBounds(187, 45, 89, 23);
		contentPane.add(btnEliminar);
		
		JButton btnBuscar = new JButton("Buscar");
		btnBuscar.setBounds(187, 79, 89, 23);
		contentPane.add(btnBuscar);
		//Acciones
		btnAgregar.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent e) {
				try{
					datos=new DatosAlumno();
					datos.setVisible(true);
					if (datos.alumno!=null){
						listahash.agregar(datos.alumno);
						lstAlumnos.setModel(listahash.mostrarLista());
					}
					datos.dispose();
				} catch (Exception ex){
					JOptionPane.showMessageDialog(null,"Error al agregar");
				}
			}
		});
		btnEliminar.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent e) {
				try{
				long noctrl=Long.parseLong(
				JOptionPane.showInputDialog("No. Control a eliminar:"));
				listahash.eliminar(noctrl);
				lstAlumnos.setModel(listahash.mostrarLista());	
				} catch (Exception ex){
					JOptionPane.showMessageDialog(null,"Error al eliminar");
				}
			}
		});
		btnBuscar.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent e) {
				try{
					long noctrl=Long.parseLong(
					JOptionPane.showInputDialog("No. Control a buscar:"));
					Alumno alux=listahash.busquedaHash(noctrl);
					if (alux!=null) 
					JOptionPane.showMessageDialog(null, alux.mostrarDatos());
				} catch (Exception ex){
					JOptionPane.showMessageDialog(null,"Error al Buscar");
				}
			}
		});
	}
}
