import java.util.*;
import java.io.*;
import javax.swing.*;
import javax.swing.filechooser.FileNameExtensionFilter;
public class OrdenamientoExterno {
	//Metodos para almacenar datos permanentemente
	public void guardar(DefaultListModel<Double> lista){
		try{
			//cuadro de dialogo para archivos
			JFileChooser fc=new JFileChooser("ARCHIVOS");
			FileNameExtensionFilter filter=new FileNameExtensionFilter("Archivo De Texto","txt");
			fc.setFileFilter(filter);
			int respuesta=fc.showSaveDialog(null);
			if (respuesta==JFileChooser.APPROVE_OPTION){
				//Obtiene el archivo seleccionado
				File archivo=fc.getSelectedFile();
				//Abre archivo para escritura de texto
				FileWriter fw=new FileWriter(archivo);
				for (int i=0;i<lista.size();i++){
					//Escribe cada valor de la lista
					if (i==0)	fw.write(""+lista.getElementAt(i));
					else fw.write(" "+lista.getElementAt(i));
				}
				fw.close(); //Se cierra archivo
			}
		} catch (Exception ex){
JOptionPane.showMessageDialog(null,"Error al guardar archivo");
		}
	}
	public DefaultListModel<Double> abrir(){
		DefaultListModel<Double> lista=new DefaultListModel<Double>();
		try{
			//cuadro de dialogo para archivos
			JFileChooser fc=new JFileChooser("ARCHIVOS");
			FileNameExtensionFilter filter=new FileNameExtensionFilter("Archivo De Texto","txt");
			fc.setFileFilter(filter);
			int respuesta=fc.showOpenDialog(null);
			if (respuesta==JFileChooser.APPROVE_OPTION){
				//Obtiene el archivo seleccionado
				File archivo=fc.getSelectedFile();
				//Abre archivo para lectura de texto
				Scanner leer=new Scanner(archivo);
				while (leer.hasNextDouble()){
					lista.addElement(leer.nextDouble());
				}
				leer.close(); //Se cierra archivo
			}
		} catch (Exception ex){
JOptionPane.showMessageDialog(null,"Error al abrir archivo");
		}
		return lista;
	}
	//Intercalacion de archivos
	public void intercalacion(){
		try{
			JFileChooser fc=new JFileChooser("ARCHIVOS");
			fc.setDialogTitle("Selecciona primer archivo a intercalar:");
			FileNameExtensionFilter filter=new FileNameExtensionFilter("Archivo De Texto","txt");
			fc.setFileFilter(filter);
			int respuesta=fc.showOpenDialog(null);
			if (respuesta==JFileChooser.APPROVE_OPTION){
				File archivo1=fc.getSelectedFile();
				fc.setDialogTitle("Selecciona segundo archivo a intercalar:");
				respuesta=fc.showOpenDialog(null);
				if (respuesta==JFileChooser.APPROVE_OPTION){
					File archivo2=fc.getSelectedFile();
					fc.setDialogTitle("Selecciona el archivo destino:");
					respuesta=fc.showSaveDialog(null);
					if (respuesta==JFileChooser.APPROVE_OPTION){
						File archivo3=fc.getSelectedFile();
						//Apertura de archivos para lectura
						Scanner f1=new Scanner(archivo1);
						Scanner f2=new Scanner(archivo2);
						//Apertura de archivo destino para escitura
						FileWriter f3=new FileWriter(archivo3);
						boolean ban1,ban2;ban1=ban2=true;
						double r1=0,r2=0;
						while ((f1.hasNextDouble() || !ban1) && 
						          (f2.hasNextDouble() || !ban2)){
							if (ban1){r1=f1.nextDouble();ban1=false;}
							if (ban2){r2=f2.nextDouble();ban2=false;}
							if (r1<r2){f3.write(""+r1+" ");ban1=true;}
							else {f3.write(""+r2+" ");ban2=true;}
							}
						//verifica si se leyo el elemento de f1 y no se copio en f3
						if (!ban1){
							f3.write(""+r1+" ");
							while (f1.hasNextDouble()){
								r1=f1.nextDouble();
								f3.write(""+r1+" ");
							}}
						//verifica si se leyo el elemento de f2 y no se copio en f3
						if (!ban2){
							f3.write(""+r2+" ");
							while (f2.hasNextDouble()){
								r2=f2.nextDouble();
								f3.write(""+r2+" ");
							}}
						f1.close();f2.close();f3.close();
						}
					}
				}
		} catch (Exception ex){
			JOptionPane.showMessageDialog(null,"Error al intercalar");
		}
		
	}
	//Mezcla directa
	public void mezclaDirecta(){
		try{
			JFileChooser fc=new JFileChooser("ARCHIVOS");
			fc.setDialogTitle("Selecciona archivo a ordenar:");
			//Para mostrar solo archivos de texto
			FileNameExtensionFilter filter=new FileNameExtensionFilter("Archivo De Texto","txt");
			fc.setFileFilter(filter);
			int respuesta=fc.showOpenDialog(null);
			if (respuesta==JFileChooser.APPROVE_OPTION){
				int part=1,n;
				File archivo=fc.getSelectedFile();
				File archivo1=new File("tmp1.txt");
				File archivo2=new File("tmp2.txt");
				Scanner f=new Scanner(archivo);
				//Cuenta los valores en el archivo
				n=0;
				while (f.hasNextDouble()){
					f.nextDouble();n++;
				}
				f.close();
				while (part<=n){
						particiona(archivo,archivo1,archivo2,part);
						fusiona(archivo,archivo1,archivo2,part);
						part=part*2;
				}
			}
		} catch (Exception ex){
			JOptionPane.showMessageDialog(null,"Error al ordenar");
		}
	}
	//realiza las particiones del archivo de tamao part.
	//archivo1 y archivo2 son archivos auxiliares
	private void particiona(File archivo,File archivo1,File archivo2,int part){
		try{
			int k,L;
			double r;
		//Abrir archivo original para lectura
		Scanner f=new Scanner(archivo);
		//Abrir archivos auxiliares para escritura
		FileWriter f1=new FileWriter(archivo1);
		FileWriter f2=new FileWriter(archivo2);
		while (f.hasNextDouble()){
			k=0;
			while (k<part&&f.hasNextDouble()){
				r=f.nextDouble();
				f1.write(""+r+" "); //Escribe valor en f1
				k++;
			}
			L=0;
			while (L<part&&f.hasNextDouble()){
				r=f.nextDouble();
				f2.write(""+r+" "); //Escribe valor en f2
				L++;
			}	
		}
		f.close();f1.close();f2.close(); //Cierre de archivo
		} catch (Exception ex){
			JOptionPane.showMessageDialog(null,"Error al particionar archivo");
		}
	}
	private void fusiona(File archivo,File archivo1,File archivo2,int part){
		try{
			double r1=0.0,r2=0.0;int k,L;boolean b1,b2;
			//Abrir archivo original para escritura
			FileWriter f=new FileWriter(archivo);
			//Abrir archivos auxiliares para lectura
			Scanner f1=new Scanner(archivo1);
			Scanner f2=new Scanner(archivo2);
			b1=b2=true;
			if (f1.hasNextDouble()){r1=f1.nextDouble();b1=false;}
			if (f2.hasNextDouble()){r2=f2.nextDouble();b2=false;}
			while ((f1.hasNextDouble()||!b1)&&(f2.hasNextDouble()||!b2)){
				k=L=0;
				while (((k<part)&&(!b1)) &&((L<part)&&(!b2))){
                     if (r1<=r2){
                    	 f.write(""+r1+" ");b1=true;k++;
                    	 if (f1.hasNextDouble()){r1=f1.nextDouble();b1=false;}
                     } else {
                    	 f.write(""+r2+" ");b2=true;L++;
                    	 if (f2.hasNextDouble()){r2=f2.nextDouble();b2=false;}
                     }
				}
				while (k<part&&!b1){
					f.write(""+r1+" ");b1=true;k++;
               	    if (f1.hasNextDouble()){r1=f1.nextDouble();b1=false;}
				}
				while (L<part&&!b2){
					f.write(""+r2+" ");b2=true;L++;
               	    if (f2.hasNextDouble()){r2=f2.nextDouble();b2=false;}
				}
			}
			if (!b1) f.write(""+r1+" ");
			if (!b2) f.write(""+r2+" ");
			while (f1.hasNextDouble()){
				r1=f1.nextDouble();
				f.write(""+r1+" ");
			}
			while (f2.hasNextDouble()){
				r2=f2.nextDouble();
				f.write(""+r2+" ");
			}
			f.close();f1.close();f2.close();
		} catch (Exception ex){
			JOptionPane.showMessageDialog(null,"Error al fusionar archivo");
		}
	}
	public void mezclaEquilibrada() {
		try{
			JFileChooser fc=new JFileChooser("ARCHIVOS");
			fc.setDialogTitle("Selecciona archivo a ordenar:");
			//Para mostrar solo archivos de texto
			FileNameExtensionFilter filter=new FileNameExtensionFilter("Archivo De Texto","txt");
			fc.setFileFilter(filter);
			int respuesta=fc.showOpenDialog(null);
			if (respuesta==JFileChooser.APPROVE_OPTION){
				//Archivo Original seleccionado por el usuario
				File archivo=fc.getSelectedFile(); 
				//Archivos temporales
				File archivo1=new File("ARCHIVOS/tmp1.txt");
				File archivo2=new File("ARCHIVOS/tmp2.txt");
				File archivo3=new File("ARCHIVOS/tmp3.txt");
				//LLamar a particin inicial
				particionInicial(archivo,archivo2,archivo3);
				//LLamar a  particin fusin
				particionFusion(archivo2,archivo3,archivo,archivo1);
				boolean band=false; //Bandera para alternar los archivos
				//Hacer mientras ninguno de los archivos este vacio
				while ((archivo1.length()>0)&&(archivo3.length()>0)) {
					if (band) {
						particionFusion(archivo2,archivo3,archivo,archivo1);
						band=false;
					} else {
						particionFusion(archivo,archivo1,archivo2,archivo3);
						band=true;
					}
				}
				//Para pasar del archivo temporal 2 al archivo original
				//En caso de que el resultado quede en f2
				if (archivo3.length()==0) {
					Scanner f2=new Scanner(archivo2); 
					FileWriter f=new FileWriter(archivo);
					double r;
					while (f2.hasNextDouble()) {
						r=f2.nextDouble();
						f.write(""+r+" ");
					}
					f.close();f2.close();
				}
			}
		} catch (Exception ex){
			JOptionPane.showMessageDialog(null,"Error al ordenar");
		}
	}
	public void particionInicial(File archivo,File archivo2,File archivo3) {
		double r,aux;boolean band;
		try {
			//Abrir el archivo original para lectura
			Scanner f=new Scanner(archivo); 
			//Abrir archivos auxiliares para escritura
			FileWriter f2=new FileWriter(archivo2);
			FileWriter f3=new FileWriter(archivo3);
			r=f.nextDouble();
			f2.write(""+r+" ");
			band=true;aux=r;
			//Repetir mientras tenga datos el archivo
			while (f.hasNextDouble()) {
				r=f.nextDouble();
				if (r>=aux) {
					aux=r;
					if (band) f2.write(""+r+" ");
					else f3.write(""+r+" ");
				} else {
					aux=r;
					if (band) {f3.write(""+r+" ");band=false;}
					else {f2.write(""+r+" ");band=true;}
				}
			}
			//Cerrar los archivos
			f.close();f2.close();f3.close();
		} catch (Exception ex){
			JOptionPane.showMessageDialog(null,"Error en particin Inicial");
		}
	}
	public void particionFusion(File archivoA,File archivoB,File archivoC,File archivoD) {
		double r1=0.0,r2=0.0,aux;boolean ban1,ban2,ban3;
		try {
			//abrir los archivos A y B para lectura
			Scanner fa=new Scanner(archivoA);
			Scanner fb=new Scanner(archivoB);
			//abrir los archivos C y D para escritura
			FileWriter fc=new FileWriter(archivoC);
			FileWriter fd=new FileWriter(archivoD);
			ban1=true;ban2=true;ban3=true;aux=-99999.99;//Un valor negativo muy alto
			//Repetir mientras existan valores en los archivos
			while (((fa.hasNextDouble())||(!ban1))&&((fb.hasNextDouble())||(!ban2))) {
				if (ban1) {r1=fa.nextDouble();ban1=false;}
				if (ban2) {r2=fb.nextDouble();ban2=false;}
				if (r1<r2) {
					if (r1>=aux) {
						if (ban3) fc.write(""+r1+" ");
						else fd.write(""+r1+" ");
						ban1=true;aux=r1;
					} else {
						if (ban3) {fc.write(""+r2+" ");ban3=false;}
						else {fd.write(""+r2+" ");ban3=true;}
						ban2=true;aux=-99999.99;
					}
				} else {
					if (r2>=aux) {
						if (ban3) fc.write(""+r2+" ");
						else fd.write(""+r2+" ");
						ban2=true;aux=r2;
					} else {
						if (ban3) {fc.write(""+r1+" ");ban3=false;}
						else {fd.write(""+r1+" ");ban3=true;}
						ban1=true;aux=-99999.99;
					}
				}
			}
			//Se hace la particion con el resto del archivo que no esta vacio
			boolean band=true;
			if (!ban1) {
				if (ban3) {
					fc.write(""+r1+" ");
					aux=r1;
					while (fa.hasNextDouble()) {
						r1=fa.nextDouble();
						if (r1>=aux) {
							aux=r1;
							if (band) fc.write(""+r1+" ");
							else fd.write(""+r1+" ");
						} else {
							aux=r1;
							if (band) {fd.write(""+r1+" ");band=false;}
							else {fc.write(""+r1+" ");band=true;}
						}
					}
				} else {
					fd.write(""+r1+" ");
					aux=r1;
					while (fa.hasNextDouble()) {
						r1=fa.nextDouble();
						if (r1>=aux) {
							aux=r1;
							if (band) fd.write(""+r1+" ");
							else fc.write(""+r1+" ");
						} else {
							aux=r1;
							if (band) {fc.write(""+r1+" ");band=false;}
							else {fd.write(""+r1+" ");band=true;}
						}
					}
				}
			}
			if (!ban2) {
				if (ban3) {
					fc.write(""+r2+" ");
					aux=r2;
					while (fb.hasNextDouble()) {
						r2=fb.nextDouble();
						if (r2>=aux) {
							aux=r2;
							if (band) fc.write(""+r2+" ");
							else fd.write(""+r2+" ");
						} else {
							aux=r2;
							if (band) {fd.write(""+r2+" ");band=false;}
							else {fc.write(""+r2+" ");band=true;}
						}
					}
				} else {
					fd.write(""+r2+" ");
					aux=r2;
					while (fb.hasNextDouble()) {
						r2=fb.nextDouble();
						if (r2>=aux) {
							aux=r2;
							if (band) fd.write(""+r2+" ");
							else fc.write(""+r2+" ");
						} else {
							aux=r2;
							if (band) {fc.write(""+r2+" ");band=false;}
							else {fd.write(""+r2+" ");band=true;}
						}
					}
				}
			}
			fa.close();fb.close();fc.close();fd.close();
		} catch (Exception ex){
			JOptionPane.showMessageDialog(null,"Error en particin-Fusin Inicial");
		} 
	}
}
