import java.awt.BorderLayout;
import java.awt.EventQueue;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.border.EmptyBorder;
import javax.swing.JMenuBar;
import javax.swing.JMenu;
import javax.swing.JLabel;
import javax.swing.JTextField;
import javax.swing.JList;
import javax.swing.JScrollPane;
import java.awt.Font;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.SwingConstants;
import java.awt.event.ActionListener;
import java.awt.event.ActionEvent;
import static javax.swing.JOptionPane.*;
import javax.swing.JMenuItem;
import javax.swing.JCheckBox;
import javax.swing.event.ChangeListener;
import javax.swing.event.ChangeEvent;
import javax.swing.JTextArea;

public class FrmOrdena extends JFrame {

	private JPanel contentPane;
	private JTextField txtValor;
	//Arreglo de valores enteros que reprentara graficamente
	//el JList. Trabaja en conjunto con dicho arreglo.
	private DefaultListModel<Integer> listaDatos=
			new DefaultListModel<Integer>();

	/**
	 * Launch the application.
	 */
	public static void main(String[] args) {
		EventQueue.invokeLater(new Runnable() {
			public void run() {
				try {
					FrmOrdena frame = new FrmOrdena();
					frame.setVisible(true);
				} catch (Exception e) {
					e.printStackTrace();
				}
			}
		});
	}

	/**
	 * Create the frame.
	 */
	public FrmOrdena() {
		setTitle("Metodos de Ordenacion Interna");
		setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
		setBounds(100, 100, 588, 505);
		
		JMenuBar menuBar = new JMenuBar();
		setJMenuBar(menuBar);
		
		JMenu mnCuadraticos = new JMenu("Cuadraticos");
		menuBar.add(mnCuadraticos);
		
		JMenuItem mntmBurbuja = new JMenuItem("Burbuja");
		mnCuadraticos.add(mntmBurbuja);
		
		JMenuItem mntmSacudida = new JMenuItem("Sacudida");
		mnCuadraticos.add(mntmSacudida);
		
		JMenuItem mntmInsercionDirecta = new JMenuItem("Insercion Directa");
		mnCuadraticos.add(mntmInsercionDirecta);
		
		JMenuItem mntmSeleccionDirecta = new JMenuItem("Seleccion Directa");
		mnCuadraticos.add(mntmSeleccionDirecta);
		
		JMenu mnLogaritmicos = new JMenu("Logaritmicos");
		menuBar.add(mnLogaritmicos);
		
		JMenuItem mntmShell = new JMenuItem("SHELL");
		mnLogaritmicos.add(mntmShell);
		
		JMenuItem mntmQuicksort = new JMenuItem("QuickSort");
		mnLogaritmicos.add(mntmQuicksort);
		
		JMenu mnOtros = new JMenu("Otros");
		menuBar.add(mnOtros);
		
		JMenuItem mntmRadixsort = new JMenuItem("RadixSort");
		mnOtros.add(mntmRadixsort);
		
		JMenuItem mntmSalir = new JMenuItem("Salir");
		menuBar.add(mntmSalir);
		contentPane = new JPanel();
		contentPane.setBorder(new EmptyBorder(5, 5, 5, 5));
		setContentPane(contentPane);
		contentPane.setLayout(null);
		
		JLabel lblValor = new JLabel("Valor:");
		lblValor.setBounds(24, 30, 46, 14);
		contentPane.add(lblValor);
		
		txtValor = new JTextField();
		txtValor.setBounds(61, 27, 67, 20);
		contentPane.add(txtValor);
		txtValor.setColumns(5);
		
		JLabel lblListaDeValores = new JLabel("Lista de Valores Original:");
		lblListaDeValores.setFont(new Font("Arial", Font.BOLD, 14));
		lblListaDeValores.setBounds(10, 55, 207, 14);
		contentPane.add(lblListaDeValores);
		
		JButton btnAgregar = new JButton("Agregar");
		btnAgregar.setBounds(198, 85, 89, 23);
		contentPane.add(btnAgregar);
		
		JButton btnEliminar = new JButton("Eliminar");
		btnEliminar.setBounds(198, 120, 89, 23);
		contentPane.add(btnEliminar);
		
		JButton btnLimpiar = new JButton("Limpiar");
		btnLimpiar.setBounds(198, 154, 89, 23);
		contentPane.add(btnLimpiar);
		
		JButton btnGenerarAleatorios = new JButton("Generar Aleatorios");
		btnGenerarAleatorios.setBounds(198, 190, 158, 31);
		contentPane.add(btnGenerarAleatorios);
		
		JScrollPane scrollPane = new JScrollPane();
		scrollPane.setBounds(10, 82, 173, 216);
		contentPane.add(scrollPane);
		
		JList<Integer> lstValores = new JList<Integer>();
		scrollPane.setViewportView(lstValores);
		
		JLabel lblListaDeValores_1 = new JLabel("Lista de Valores Ordenados:");
		lblListaDeValores_1.setFont(new Font("Arial", Font.BOLD, 14));
		lblListaDeValores_1.setBounds(364, 56, 198, 14);
		contentPane.add(lblListaDeValores_1);
		
		JScrollPane scrollOrdena = new JScrollPane();
		scrollOrdena.setBounds(366, 82, 196, 216);
		contentPane.add(scrollOrdena);
		
		JList<Integer> lstOrdenados = new JList<Integer>();
		scrollOrdena.setViewportView(lstOrdenados);
		//Asocia el DefaulListModel con el JList de lista original
		lstValores.setModel(listaDatos);
		
		JCheckBox chckbxEscribirPasadas = new JCheckBox("Escribir Pasadas");
		chckbxEscribirPasadas.setBounds(359, 26, 173, 23);
		contentPane.add(chckbxEscribirPasadas);
		
		JScrollPane scrollPasadas = new JScrollPane();
		scrollPasadas.setVisible(false);
		scrollPasadas.setBounds(10, 309, 552, 133);
		contentPane.add(scrollPasadas);
		
		JTextArea txtPasadas = new JTextArea();
		scrollPasadas.setViewportView(txtPasadas);
		//Acciones de los botones
		btnAgregar.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent arg0) {
				try {
					int valor=Integer.parseInt(txtValor.getText());
					//Agregar valor elemento seleccionado en el DefaulListModel
					listaDatos.addElement(valor);
				} catch (Exception ex){
					showMessageDialog(null,"Valor incorrecto");
				} finally {
					txtValor.setText("");//Limpia caja de texto
				}
			}
		});
		btnEliminar.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent arg0) {
				try{
					//obtiene la posicion seleccionada en el JList
					int posicion=lstValores.getSelectedIndex();
					if (posicion>=0){
						//Eliminar valor seleccionado en el DefaulListModel
						listaDatos.removeElementAt(posicion);
					} 
				else showMessageDialog(null,"Valor no seleccionado");
				} catch (Exception ex){
					showMessageDialog(null,"Error al Eliminar");
				}
			}
		});
		btnLimpiar.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent arg0) {
				listaDatos.clear();
			}
		});
		btnGenerarAleatorios.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent arg0) {
				try {
					int inicio=Integer.parseInt(
							showInputDialog("Limite inferior:"));
					int fin=Integer.parseInt(
							showInputDialog("Limite Superior:"));
					int cantidad=Integer.parseInt(
							showInputDialog("Cantidad:"));
					listaDatos.clear();int valor;
					for (int i=1;i<=cantidad;i++){
						valor=(int)(Math.random()*(fin-inicio+1)+inicio);
						listaDatos.addElement(valor);
					}
				} catch (Exception ex){
			showMessageDialog(null,"Error al Generar Aleatorios");
				}
			}
		});
		mntmBurbuja.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent arg0) {
				try{
					Integer datos[]=new Integer[listaDatos.size()];
					//Copia los elemento de la lista en el arreglo datos
					listaDatos.copyInto(datos);
					//Se invoca el metodo de ordenamiento interno
					Ordena.burbuja(datos,chckbxEscribirPasadas.isSelected(),txtPasadas);
					//Se establece la lista ordenada en el JList 
					//para representar graficamente los datos ordenados
					lstOrdenados.setModel(Ordena.convierte(datos));
			} catch (Exception ex){
					showMessageDialog(null,"Error al ordenar");
				}
			}
		});
		mntmSacudida.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent arg0) {
				try{
					Integer datos[]=new Integer[listaDatos.size()];
					//Copia los elemento de la lista en el arreglo datos
					listaDatos.copyInto(datos);
				    //Aqui va la llama o invoacion al otro Metodo de Ordenamiento
					Ordena.sacudida(datos,chckbxEscribirPasadas.isSelected(),txtPasadas);
					lstOrdenados.setModel(Ordena.convierte(datos));
			} catch (Exception ex){
					showMessageDialog(null,"Error al ordenar");
				}
			}
		});
		mntmSalir.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent arg0) {
				dispose();//Liberar el espacio de memoria que usa la ventana
				System.exit(0);//Terminar la aplicacion
			}
		});
		chckbxEscribirPasadas.addChangeListener(new ChangeListener() {
			public void stateChanged(ChangeEvent arg0) {
				if (chckbxEscribirPasadas.isSelected()){
					scrollPasadas.setVisible(true);
					txtPasadas.setVisible(true);
					txtPasadas.setText("");
				} else {
					scrollPasadas.setVisible(false);
					txtPasadas.setVisible(false);
					txtPasadas.setText("");
				}
			}
		});
		mntmInsercionDirecta.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent arg0) {
				try{
					Integer datos[]=new Integer[listaDatos.size()];
					//Copia los elemento de la lista en el arreglo datos
					listaDatos.copyInto(datos);
					//Se invoca el metodo de ordenamiento interno
					Ordena.insercionDirecta(datos,chckbxEscribirPasadas.isSelected(),txtPasadas);
					//Se establece la lista ordenada en el JList 
					//para representar graficamente los datos ordenados
					lstOrdenados.setModel(Ordena.convierte(datos));
			} catch (Exception ex){
					showMessageDialog(null,"Error al ordenar");
				}
			}
		});
		mntmSeleccionDirecta.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent arg0) {
				try{
					Integer datos[]=new Integer[listaDatos.size()];
					//Copia los elemento de la lista en el arreglo datos
					listaDatos.copyInto(datos);
					//Se invoca el metodo de ordenamiento interno
					Ordena.seleccionDirecta(datos,chckbxEscribirPasadas.isSelected(),txtPasadas);
					//Se establece la lista ordenada en el JList 
					//para representar graficamente los datos ordenados
					lstOrdenados.setModel(Ordena.convierte(datos));
			} catch (Exception ex){
					showMessageDialog(null,"Error al ordenar");
				}
			}
		});
		mntmShell.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent arg0) {
				try{
					Integer datos[]=new Integer[listaDatos.size()];
					//Copia los elemento de la lista en el arreglo datos
					listaDatos.copyInto(datos);
					//Se invoca el metodo de ordenamiento interno
					Ordena.shellSort(datos,chckbxEscribirPasadas.isSelected(),txtPasadas);
					//Se establece la lista ordenada en el JList 
					//para representar graficamente los datos ordenados
					lstOrdenados.setModel(Ordena.convierte(datos));
			} catch (Exception ex){
					showMessageDialog(null,"Error al ordenar");
				}
			}
		});
		mntmQuicksort.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent arg0) {
				try{
					Integer datos[]=new Integer[listaDatos.size()];
					//Copia los elemento de la lista en el arreglo datos
					listaDatos.copyInto(datos);
					//Se invoca el metodo de ordenamiento interno
					Ordena.quickSort(datos,chckbxEscribirPasadas.isSelected(),txtPasadas);
					//Se establece la lista ordenada en el JList 
					//para representar graficamente los datos ordenados
					lstOrdenados.setModel(Ordena.convierte(datos));
				} catch (Exception ex){
					showMessageDialog(null,"Error al ordenar");
				}
			}	
		});
		mntmRadixsort.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent e) {
				try{
					Integer datos[]=new Integer[listaDatos.size()];
					//Copia los elemento de la lista en el arreglo datos
					listaDatos.copyInto(datos);
					//Se invoca el metodo de ordenamiento interno
					Ordena.radixSort(datos,chckbxEscribirPasadas.isSelected(),txtPasadas);
					//Se establece la lista ordenada en el JList 
					//para representar graficamente los datos ordenados
					lstOrdenados.setModel(Ordena.convierte(datos));
				} catch (Exception ex){
					showMessageDialog(null,"Error al ordenar");
				}
			}
		});
	}
}
