package Grafo;
import java.util.LinkedList;
//Clase para implementar la lista de adyacencia
public class GrafoAdcia           
{
  int numVerts;          
  VerticeAdy [] tablAdc;

    public GrafoAdcia(int mx)
    {
      tablAdc = new VerticeAdy[mx];
      numVerts = 0;
    }

    
    public int numeroDeVertices()
    {
      return numVerts;
    }

    public VerticeAdy[] vertices()
    {
      return tablAdc;
    }
         //La operacin listaAdyc()devuelve la lista de adyacencia del vrtice v.
    public LinkedList<Arco> listaAdyc(int v) throws Exception 
    {
      if (v < 0 || v >= numVerts) 
        throw new Exception(" Vrtice fuera de rango ");
      return tablAdc[v].lad;
    }

    public void nuevoVertice (String nom)
    {
      boolean esta = numVertice(nom) >= 0;
      if (!esta) 
      {
        VerticeAdy v = new VerticeAdy(nom); 
        v.asigVert(numVerts);
        tablAdc [numVerts++] = v;
      }
    } 
    //Obtener el nombre del vertice
    public String nomVertice(int numero) {
    	return tablAdc[numero].nomVertice();
    }
    
      // numVertice()busca el vrtice en la tabla. Devuelve -1 si no lo encuentra:
    public int numVertice(String nm)
    {
      VerticeAdy v = new VerticeAdy(nm);
      boolean encontrado = false;
      int i = 0;
      for (; (i < numVerts) && !encontrado; )
      {
        encontrado = tablAdc [i].equals(v);
        if (!encontrado) i++ ; 
      }
      return (i < numVerts) ? i : -1 ;
    }
  
    public void nuevoArco(String a, String b,int peso) throws Exception
    {
      if (!adyacente(a, b))
      {
        int va = numVertice(a);
        int vb = numVertice(b);
        if (va < 0 || vb < 0)
         throw new Exception("Vrtice no existe");
        Arco ab = new Arco(vb,peso);
        tablAdc[va].lad.add(ab);
      }
    }

  public void borrarArco(String a, String b)throws Exception
  {
            int va, vb;
      va = numVertice(a);
      vb = numVertice(b);
      if (va < 0 || vb < 0) throw new Exception ("Vrtice no existe");
           Arco ab = new Arco(vb);
      tablAdc[va].lad.remove(ab);
    }

  boolean adyacente(String a, String b)throws Exception
  {
          int va, vb;
      va = numVertice(a);
      vb = numVertice(b);
      if (va < 0 || vb < 0) throw new Exception ("Vrtice no existe");
        if (tablAdc[va].lad.indexOf(new Arco(vb)) >=0)  
          return true;
        else
          return false;
    }

  boolean adyacente(int va, int vb)throws Exception
  {
      if (va < 0 || vb < 0) throw new Exception ("Vrtice no existe");
      if (tablAdc[va].lad.indexOf(new Arco(vb)) >=0)  
        return true;
      else
        return false;
    }
  }

