package itz;
import javax.swing.*;
import javax.swing.tree.DefaultMutableTreeNode;
public class ArbolBinarioBusqueda <T extends Comparable<T>> {
	//Atributos
	private NodoArbol<T> raiz;
	private JDialog ventana;
	//Constructor
	public ArbolBinarioBusqueda() {
		raiz=null; //Arbol vacio
	}
	//Operaciones basicas
	private NodoArbol<T> insercion(NodoArbol<T> q, T infoaux){
		/* Realiza la insercion de un elemento en un rbol binario de busqueda.
		 * infoaux contiene la informacin del objeto que se quiere insertar
		 */
		NodoArbol<T> otro;//apuntador auxiliar
		if (q!=null) {
			//Buscar posicion correspondiente
			if (infoaux.compareTo(q.getInfo())<0) 
				q.setRamaIzq(insercion(q.getRamaIzq(),infoaux)); //llamada recursiva por rama izquierda
			else if (infoaux.compareTo(q.getInfo())>0)
				q.setRamaDer(insercion(q.getRamaDer(),infoaux)); //llamada recursiva por rama derecha
			else JOptionPane.showMessageDialog(null, "El objeto ya existe en el arbol");
			return (q); //retorna un subarbol
		} else {
			//Inserta el nuevo nodo
			otro=new NodoArbol<T>(infoaux);
			return (otro); // retorna un subarbol con el nodo insertado
		}
	}
	public void insertar(T objetox) {
		raiz=insercion(raiz,objetox); //Punto de inicio de la busqueda
	}
	private NodoArbol<T> eliminacion(NodoArbol<T> q, T infoaux){
		/*Realiza la eliminacin de un elemento u objeto en un arbol binario de busqueda
		 * infoaux contiene la informacin del objeto que se quiere eliminar
		 */
		NodoArbol<T> aux,aux1,otro; //Variables auxiliares de referencia a nododos de tipo arbol
		if (q!=null) {
			if (infoaux.compareTo(q.getInfo())<0)
				q.setRamaIzq(eliminacion(q.getRamaIzq(),infoaux)); //llamada recursiva por rama izquierda
			else if (infoaux.compareTo(q.getInfo())>0)
				q.setRamaDer(eliminacion(q.getRamaDer(),infoaux)); //llamada recursiva por rama derecha
			else { //Se encontro el nodo a eliminar
				otro=q;
				if (otro.getRamaDer()==null) q=otro.getRamaIzq(); //El hijo izquierdo ocupa el lugar del padre
				else if (otro.getRamaIzq()==null) q=otro.getRamaDer();  //El hijo derecho ocupa el lugar del padre
				else { //reacomodar el rbol
					aux=otro.getRamaIzq();aux1=aux;
					//Buscar el predecesor (mayor de la rama izquierda)
					while (aux.getRamaDer()!=null) {
						aux1=aux;
						aux=aux.getRamaDer();
					}
					otro.setInfo(aux.getInfo()); //Copia del nodo predecesor al nodo a eliminar
					if (aux1==aux) otro.setRamaIzq(aux.getRamaDer()); //El nodo a eliminar es hoja
					else aux1.setRamaDer(aux.getRamaIzq());
					otro=aux;
					}
				}
			   //Eliminar nodo
			   otro=null;			
		} else JOptionPane.showMessageDialog(null, "El objeto no existe en el arbol");
		return q;
	}
	public void eliminar(T objetox) {
		raiz=eliminacion(raiz,objetox);
	}
	
	private void busqueda(NodoArbol<T> q, T infoaux){
	/*Localizacion de un nodo en un ABB
	 * q es una variable de tipo puntero que apunta a la raiz del rbol
	 * infoaux es el objeto a buscar
	 */
		if (q!=null) {
			//Buscar posicion correspondiente
			if (infoaux.compareTo(q.getInfo())<0) 
				q.setRamaIzq(insercion(q.getRamaIzq(),infoaux)); //llamada recursiva por rama izquierda
			else if (infoaux.compareTo(q.getInfo())>0)
				q.setRamaDer(insercion(q.getRamaDer(),infoaux)); //llamada recursiva por rama derecha
			else  JOptionPane.showMessageDialog(null, "El objeto se encuentra en el arbol:\n"+q.getInfo());
		} else JOptionPane.showMessageDialog(null, "El objeto no existe en el arbol");
	}
	public void buscar(T objetox) {
		busqueda(raiz,objetox);
	}
	//Operacion de recorrido
	public StringBuilder recorrido(int tipo) {
		StringBuilder salida=new StringBuilder();
		switch (tipo) {
		case 1:preorden(raiz,salida);break;
		case 2:inorden(raiz,salida);break;
		case 3:postorden(raiz,salida);break;
		}
		return salida;
	}
	private void preorden(NodoArbol<T> q,StringBuilder salida) {
		if (q!=null) {
			salida.append(q.getInfo()+",");//Visitar raiz
			preorden(q.getRamaIzq(),salida); //LLamada recursiva por la rama izquierda
			preorden(q.getRamaDer(),salida); //LLamada recursiva por la rama derecha
		}
	}
	private void inorden(NodoArbol<T> q,StringBuilder salida) {
		if (q!=null) {
			inorden(q.getRamaIzq(),salida); //LLamada recursiva por la rama izquierda
			salida.append(q.getInfo()+",");//Visitar raiz
			inorden(q.getRamaDer(),salida); //LLamada recursiva por la rama derecha
		}
	}
	private void postorden(NodoArbol<T> q,StringBuilder salida) {
		if (q!=null) {
			postorden(q.getRamaIzq(),salida); //LLamada recursiva por la rama izquierda
			postorden(q.getRamaDer(),salida); //LLamada recursiva por la rama derecha
			salida.append(q.getInfo()+",");//Visitar raiz
		}
	}
	//Metodo para representar graficamente el ABB
	private void preordenGrafico(NodoArbol<T> q,DefaultMutableTreeNode nodo) {
		if (q!=null) {
			DefaultMutableTreeNode nodoaux=new DefaultMutableTreeNode(q.getInfo());
			nodo.add(nodoaux); //Visitar la raiz
			preordenGrafico(q.getRamaIzq(),nodoaux); //LLamada recursiva por la rama izquierda
			preordenGrafico(q.getRamaDer(),nodoaux); //LLamada recursiva por la rama derecha
		}
	}
	public void mostrar() {
		ventana=new JDialog();
		ventana.setTitle("Arbol binario de busqueda");
		ventana.setSize(300,300);
		DefaultMutableTreeNode nodoraiz=new DefaultMutableTreeNode("Arbol Binario");
		JTree arbol=new JTree(nodoraiz);
		ventana.add(arbol);
		preordenGrafico(raiz,nodoraiz);
		ventana.setModal(true);
		ventana.setVisible(true);
	}
}
