import java.util.Stack; //Biblioteca de clase para colecciones
import java.util.Scanner;
public class EquilibraSimbolos {
	public static void main(String arg[]) {
		Scanner leer=new Scanner(System.in);
		System.out.print("Teclea una cadena de entrada:");
		String cadEntrada=leer.nextLine();
	    if (verificaSimbolos(cadEntrada)) System.out.println("Simbolos Equilibrados");
	    else System.out.println("Simbolos no equilibrados");
	}
	public static boolean verificaSimbolos(String cadena)  {
		Stack<String> pila = new Stack<String>(); //Crea una instancia de la clase pila generica
		String apertura="{,(,["; //simbolos de apertura
		String cierre="},),]"; //Simbolos de cierre
		//Recorre la cadena carecter por caracter para su analisis
		String caracter;boolean error=false;//inicialmente se asume no hay error
		for (int i=0;i<cadena.length();i++){
			caracter=""+cadena.charAt(i);//Caracter analizado convertido a cadena
			if (apertura.contains(caracter)) pila.push(caracter); //Si el caracter es de apertura
			else if (cierre.contains(caracter)) { //Si caracter es de cierre
				if (pila.empty()) {error=true;break;} //error y sale del ciclo incondicionalmente
				else {
					switch (pila.peek()){
					case "[":error=caracter.equals("]")?false:true;break;
					case "(":error=caracter.equals(")")?false:true;break;
					case "{":error=caracter.equals("}")?false:true;break;
					}
					if (error) break; //No corresponden simbolos
					else pila.pop(); //Si corresponde lo simbolos se saca el de apertura
				}
			}
		}
		if (!pila.empty()) error=true;
		return !error; //Si no hubo error, simbolos estan equilibrados
		}
}

