import java.awt.BorderLayout;
import java.awt.EventQueue;

import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.border.EmptyBorder;
import javax.swing.JLabel;
import javax.swing.JTextField;
import javax.swing.JButton;
import java.awt.Font;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import java.awt.event.ActionListener;
import java.awt.event.ActionEvent;

public class UsaPila extends JFrame {

	private JPanel contentPane;
	private JTextField txtNSS;
	private JTextField txtNombre;
	private JTextField txtEnfermedad;
	//Crear un objeto de tipo Pila
	Pila<Paciente> pila=new Pila<Paciente>(5);

	/**
	 * Launch the application.
	 */
	public static void main(String[] args) {
		EventQueue.invokeLater(new Runnable() {
			public void run() {
				try {
					UsaPila frame = new UsaPila();
					frame.setVisible(true);
				} catch (Exception e) {
					e.printStackTrace();
				}
			}
		});
	}

	/**
	 * Create the frame.
	 */
	public UsaPila() {
		setTitle("Pila de Pacientes");
		setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
		setBounds(100, 100, 514, 393);
		contentPane = new JPanel();
		contentPane.setBorder(new EmptyBorder(5, 5, 5, 5));
		setContentPane(contentPane);
		contentPane.setLayout(null);
		
		JPanel panel = new JPanel();
		panel.setBounds(10, 11, 481, 96);
		contentPane.add(panel);
		panel.setLayout(null);
		
		JLabel lblNss = new JLabel("NSS:");
		lblNss.setBounds(21, 11, 73, 14);
		panel.add(lblNss);
		
		JLabel lblNombre = new JLabel("Nombre:");
		lblNombre.setBounds(21, 37, 73, 14);
		panel.add(lblNombre);
		
		JLabel lblEnfermedad = new JLabel("Enfermedad:");
		lblEnfermedad.setBounds(21, 62, 94, 14);
		panel.add(lblEnfermedad);
		
		txtNSS = new JTextField();
		txtNSS.setBounds(133, 8, 120, 20);
		panel.add(txtNSS);
		txtNSS.setColumns(10);
		
		txtNombre = new JTextField();
		txtNombre.setBounds(133, 34, 297, 20);
		panel.add(txtNombre);
		txtNombre.setColumns(10);
		
		txtEnfermedad = new JTextField();
		txtEnfermedad.setBounds(132, 59, 298, 20);
		panel.add(txtEnfermedad);
		txtEnfermedad.setColumns(10);
		
		JButton btnLimpiar = new JButton("Limpiar");
		btnLimpiar.setBounds(197, 116, 89, 23);
		contentPane.add(btnLimpiar);
		
		JLabel lblPilaDePacientes = new JLabel("Pila de Pacientes:");
		lblPilaDePacientes.setFont(new Font("Arial", Font.BOLD, 16));
		lblPilaDePacientes.setBounds(10, 118, 241, 14);
		contentPane.add(lblPilaDePacientes);
		
		JScrollPane scrollPane = new JScrollPane();
		scrollPane.setBounds(10, 143, 288, 200);
		contentPane.add(scrollPane);
		
		JList<Paciente> listPacientes = new JList<Paciente>();
		scrollPane.setViewportView(listPacientes);
		
		JButton btnVaciarPila = new JButton("Vaciar Pila");
		btnVaciarPila.setBounds(296, 118, 141, 23);
		contentPane.add(btnVaciarPila);
		
		JButton btnPush = new JButton("Push");
		btnPush.setBounds(320, 189, 89, 23);
		contentPane.add(btnPush);
		
		JButton btnPop = new JButton("Pop");
		btnPop.setBounds(320, 223, 89, 23);
		contentPane.add(btnPop);
		//Programacion de eventos y operaciones
		btnLimpiar.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent arg0) {
				limpiar();
			}
		});
		btnVaciarPila.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent e) {
				pila.vaciar();
				listPacientes.setModel(pila.mostrar());
			}
		});
		btnPush.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent e) {
				try{
					int nss=Integer.parseInt(txtNSS.getText());
					String nom=txtNombre.getText();
					String enf=txtEnfermedad.getText();
					//Crear un objeto de tipo paciente
					Paciente p=new Paciente(nss,nom,enf);
					if (pila.push(p)) {limpiar();
					listPacientes.setModel(pila.mostrar()); //Actualiza JList
					}
					else  {
				JOptionPane.showMessageDialog(null,"Desbordamiento o Pila llena");
				limpiar();}
				} catch (Exception ex){
			      JOptionPane.showMessageDialog(null,"Datos incorrectos");
			      limpiar();
				}
			}
		});
		btnPop.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent e) {
				try{
					Paciente p=pila.pop();
					if (p!=null){
						txtNSS.setText(""+p.getNss());
						txtNombre.setText(p.getNombre());
						txtEnfermedad.setText(p.getEnfermedad());
						listPacientes.setModel(pila.mostrar());
					} else throw new Exception("Subdesbordamiento o pila vacia");
				} catch (Exception ex){
					JOptionPane.showMessageDialog(null,"Error:"+ex.getMessage());
					limpiar();
				}
			}
		});
	}
	public void limpiar(){
		txtNSS.setText("");
		txtNombre.setText("");
		txtEnfermedad.setText("");
	}
}
