import javax.swing.DefaultListModel;

//Implementacion de la estructura de datos pila generica
//Una pila es una lista con la politica LIFO
public class Pila <T> 
{    //Estructura de datos(arreglo unidimensional)
	private T[] pila;
	private int maximo;
	private int tope;
	public Pila(int maximo){
		tope=-1; //Pila inicialmente esta vacia
		pila=(T[]) new Object[maximo]; //Crea los espacios necesarios para la pila generica
		this.maximo=maximo-1; //Puesto que el arreglo empieza en cero	
	}
	//Operaciones
	public boolean estaLLena(){
		if (tope==maximo) return true;
		else return false;
	}
	public boolean estaVacia(){
		if (tope>=0) return false;
		else return true;
	}
	public boolean push(T dato){
		if (!estaLLena()){
			tope=tope+1;
			pila[tope]=dato;
			return true;
		} else return false;
	}
	public T pop(){
		T dato=null; //Pila vacia
		if (!estaVacia()){
			dato=pila[tope];
			tope=tope-1;
		} 
		return dato;
	}
	public T peek() //Regresa el dato en el tope de la pila sin sacarlo
	{
		T dato=null; //Pila vacia
		if (!estaVacia()){
			dato=pila[tope];
		} 
		return dato;
	}
	public void vaciar(){
		tope=-1;
	}
	//Para Simular la pila en interfaz grafica
	public DefaultListModel<T> mostrar(){
		DefaultListModel<T> modelo=new DefaultListModel<T>();
		for (int i=tope;i>=0;i--)
			modelo.addElement(pila[i]);
		return modelo;
	}
}
