package itz;

import java.io.FileOutputStream;
import java.util.HashMap;

import com.lowagie.text.Element;
import com.lowagie.text.Image;
import com.lowagie.text.PageSize;
import com.lowagie.text.pdf.BaseFont;
import com.lowagie.text.pdf.PdfContentByte;
import com.lowagie.text.pdf.PdfReader;
import com.lowagie.text.pdf.PdfStamper;

public class AddWatermarkPageNumbers {
    public static void main(String[] args) {
        System.out.println("Agregan Marca de Agua y Numero de paginas");
        try {
            PdfReader reader = new PdfReader("Capitulo.pdf");
            int n = reader.getNumberOfPages();
            // crea un stamper que copiara el documento a un nuevo archivo
            PdfStamper stamp = new PdfStamper(reader, 
               new FileOutputStream("Resultado.pdf"));
            // agregando algunos metadatos
            HashMap moreInfo = new HashMap();
            moreInfo.put("Author", "Bruno Lowagie");
            stamp.setMoreInfo(moreInfo);
            // agregando el contenido de cada pagina
            int i = 0;
            PdfContentByte under;
            PdfContentByte over;
            Image img = Image.getInstance("itz2.jpg");
            BaseFont bf = 
               BaseFont.createFont
                 (BaseFont.HELVETICA, BaseFont.WINANSI, BaseFont.EMBEDDED);
            img.setAbsolutePosition(200, 400);
            while (i < n) {
                i++;
                // Marca de Agua atras de pagina existente
                under = stamp.getUnderContent(i);
                under.addImage(img);
                // Texto encima de pagina existente
                over = stamp.getOverContent(i);
                over.beginText();
                over.setFontAndSize(bf, 18);
                over.setTextMatrix(30, 30);
                over.showText("page " + i);
                over.setFontAndSize(bf, 32);
                over.showTextAligned
                   (Element.ALIGN_LEFT, "DUPLICADO", 230, 430, 45);
                over.endText();
            }
            // agregando una pagina extra
            stamp.insertPage(1, PageSize.A4);
            over = stamp.getOverContent(1);
            over.beginText();
            over.setFontAndSize(bf, 18);
            over.showTextAligned(Element.ALIGN_LEFT, 
                    "DUPLICADO DE UN DOMUNENTO PDF EXISTENTE", 30, 600, 0);
            over.endText();
            // agregando una pagina de otro documento
            PdfReader reader2 = new PdfReader("anotacion.pdf");
            under = stamp.getUnderContent(1);
            under.addTemplate
                (stamp.getImportedPage(reader2, 1), 1, 0, 0, 1, 0, 0);
            // cerrando PdfStamper generara el nuevo archivo PDF
            stamp.close();
        }
        catch (Exception de) {
            de.printStackTrace();
        }
    }
}
