package itz;
import java.io.*;
import javax.xml.parsers.*;
import org.w3c.dom.*;

public class LeerXML {

	public static void main(String[] args) {
		try {
			File file = new File("coches.xml");
			DocumentBuilderFactory dbFactory = DocumentBuilderFactory.newInstance();
			DocumentBuilder dBuilder = dbFactory.newDocumentBuilder();
			Document doc = dBuilder.parse(file);
			// estos mtodos podemos usarlos combinados para normalizar el archivo XML
			doc.getDocumentElement().normalize();
			// almacenamos los nodos para luego mostrar la
			// cantidad de ellos con el mtodo getLength()
			NodeList nList = doc.getElementsByTagName("coche");
			System.out.println("Nmero de coches: " + nList.getLength());
			for(int temp = 0; temp < nList.getLength(); temp++) {
				  Node nNode = nList.item(temp);

				  if(nNode.getNodeType() == Node.ELEMENT_NODE) {
				    Element eElement = (Element) nNode;

				    System.out.println("\nCoche id: " + eElement.getAttribute("id"));
				    System.out.println("Marca: "
				                + eElement.getElementsByTagName("marca").item(0).getTextContent());
				    System.out.println("Modelo: "
				                + eElement.getElementsByTagName("modelo").item(0).getTextContent());
				    System.out.println("Cilindrada: "
				                + eElement.getElementsByTagName("cilindrada").item(0).getTextContent());
				  }
				}
			  
		} catch (Exception ex) {
			System.out.println("Error al abrir archivo");
		}
	}
}
