package itz;
import java.io.*;
import javax.xml.parsers.*;
import javax.xml.transform.*;
import javax.xml.transform.dom.*;
import javax.xml.transform.stream.StreamResult;

import org.w3c.dom.*;
import javax.xml.*;

public class EscribirXML {

	public static void main(String[] args) {
		try {
			  DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
			  DocumentBuilder db = dbf.newDocumentBuilder();
			  Document doc = db.newDocument();

			  // definimos el elemento raz del documento
			  Element eRaiz = doc.createElement("concesionario");
			  doc.appendChild(eRaiz);

			  // definimos el nodo que contendr los elementos
			  Element eCoche = doc.createElement("coche");
			  eRaiz.appendChild(eCoche);

			  // atributo para el nodo coche
			  Attr attr = doc.createAttribute("id");
			  attr.setValue("1");
			  eCoche.setAttributeNode(attr);

			  // definimos cada uno de los elementos y le asignamos un valor
			  Element eMarca = doc.createElement("marca");
			  eMarca.appendChild(doc.createTextNode("Renault"));
			  eCoche.appendChild(eMarca);

			  Element eModelo = doc.createElement("modelo");
			  eModelo.appendChild(doc.createTextNode("Megano"));
			  eCoche.appendChild(eModelo);

			  Element eCilindrada = doc.createElement("cilindrada");
			  eCilindrada.appendChild(doc.createTextNode("1.5"));
			  eCoche.appendChild(eCilindrada);

			  // clases necesarias finalizar la creacin del archivo XML
			  TransformerFactory transformerFactory = TransformerFactory.newInstance();
			  Transformer transformer = transformerFactory.newTransformer();
			  DOMSource source = new DOMSource(doc);
			  StreamResult result = new StreamResult(new File("coches2.xml"));

			  transformer.transform(source, result);
			  System.out.println("Generacion exitosa");
			} catch(Exception e) {
			  e.printStackTrace();
			}
	}
}
