package itz; 
import java.io.*;
//////////////////////////////////////////////////////////////////
//Aplicacin para trabajar con un fichero accedido aleatoriamente
//
public class UsaListaTfnos
{
	// Definir una referencia al flujo estndar de salida: flujoS
	static PrintStream flujoS = System.out;

	static CListaTfnos listatfnos;

	public static void imprimirListaTfnos() throws IOException
	{
		// Crear un flujo hacia la impresora
		FileWriter flujoS = new FileWriter("salida.txt");

		String crlf = "\r\n"; // cambiar a la siguiente lnea
		String ff = "\f";     // saltar a la siguiente pgina
		Integer i;            // referencia a un objeto Integer
		Long l;               // referencia a un objeto Long
		int nregs = listatfnos.longitud(); // nmero de registros

		for (int n = 0; n < nregs; n++)
		{
			// Saltar pgina inicialmente y despus cada 60 lneas
			if (n % 60 == 0) flujoS.write(ff);
			// Imprimir el registro n de la lista de telfonos
			i = new Integer(n); // nmero de registro
			flujoS.write("Registro: " + i.toString() + crlf);
			flujoS.write(listatfnos.valorEn(n).obtenerNombre() + crlf);
			flujoS.write(listatfnos.valorEn(n).obtenerDireccin() + crlf);
			l = new Long(listatfnos.valorEn(n).obtenerTelfono());
			flujoS.write(l.toString() + crlf);
			flujoS.write(crlf); // saltar una lnea
		}
		flujoS.write(ff); // saltar a la siguiente pgina
		flujoS.close();   // cerrar el flujo hacia la impresora
	}

	public static boolean modificar(int nreg) throws IOException
	{
		String nombre, direccin;
		long telfono;
		int op;
		// Leer el registro
		CPersona obj = listatfnos.valorEn(nreg);
		if (obj == null) return false;

		// Modificar el registro
		do
		{
			flujoS.print("\n\n");
			flujoS.println("Modificar el dato:");
			flujoS.println("1. Nombre");
			flujoS.println("2. Direccin");
			flujoS.println("3. Telfono");
			flujoS.println("4. Salir y salvar los cambios");
			flujoS.println("5. Salir sin salvar los cambios");
			flujoS.println();
			flujoS.print("   Opcin: ");
			op = Leer.datoInt();

			switch( op )
			{
			case 1: // modificar nombre
				flujoS.print("nombre:    ");
				nombre = Leer.dato();
				obj.asignarNombre(nombre);
				break;
			case 2: // modificar direccin
				flujoS.print("direccin: ");
				direccin = Leer.dato();
				obj.asignarDireccin(direccin);
				break;
			case 3: // modificar telfono
				flujoS.print("telfono:  ");
				telfono = Leer.datoLong();
				obj.asignarTelfono(telfono);
				break;
			case 4: // guardar los cambios
				break;
			case 5: // salir sin guardar los cambios
				break;
			}
		}
		while( op != 4 && op != 5);
		if (op == 4)
		{
			listatfnos.ponerValorEn(nreg, obj);             
			return true;
		}
		else
			return false;
	}

	public static void actualizar(File fActual) throws IOException 
	{    // Crear un fichero temporal
		File ficheroTemp = new File("listatfnos.tmp");
		CListaTfnos ftemp = new CListaTfnos(ficheroTemp);    
		int nregs = listatfnos.longitud();
		// Copiar en el fichero temporal todos los registros del
		// fichero actual que en su campo telfono no tengan un 0
		CPersona obj;
		for ( int reg_i = 0; reg_i < nregs; reg_i++ )
		{
			obj = listatfnos.valorEn(reg_i);
			if (obj.obtenerTelfono() != 0)
				ftemp.aadir(obj);
		}
		listatfnos.cerrar();
		ftemp.cerrar();
		fActual.delete();
		if (!ficheroTemp.renameTo(fActual))
			throw new IOException("no se renombr el fichero");
	}  

	public static int men()
	{
		flujoS.print("\n\n");
		flujoS.println("1. Buscar");
		flujoS.println("2. Buscar siguiente");
		flujoS.println("3. Modificar");
		flujoS.println("4. Aadir");
		flujoS.println("5. Eliminar");
		flujoS.println("6. Imprimir");    
		flujoS.println("7. Salir");    
		flujoS.println();
		flujoS.print("   Opcin: ");
		int op;
		do
			op = Leer.datoInt();
		while (op < 1 || op > 7);
		return op;
	}

	public static void main(String[] args)
	{
		int opcin = 0, pos = -1;
		String cadenabuscar = null;
		String nombre, direccin;
		long telfono;
		boolean eliminado = false;
		boolean modificado = false;

		try
		{
			// Crear un objeto lista de telfonos vaco (con 0 elementos)
			// o con el contenido del fichero listatfnos.dat si existe.
			File fichero = new File("listatfnos.dat");
			listatfnos = new CListaTfnos(fichero);

			do
			{
				opcin = men();
				switch (opcin)
				{
				case 1: // buscar
					flujoS.print("conjunto de caracteres a buscar ");
					cadenabuscar = Leer.dato();
					pos = listatfnos.buscar(cadenabuscar, 0);
					if (pos == -1)
						if (listatfnos.longitud() != 0)
							flujoS.println("bsqueda fallida");
						else
							flujoS.println("lista vaca");
					else
					{
						flujoS.println("Nmero de registro: " + pos);
						flujoS.println(listatfnos.valorEn(pos).obtenerNombre());
						flujoS.println(listatfnos.valorEn(pos).obtenerDireccin());
						flujoS.println(listatfnos.valorEn(pos).obtenerTelfono());
					}
					break;
				case 2: // buscar siguiente
					pos = listatfnos.buscar(cadenabuscar, pos + 1);
					if (pos == -1)
						if (listatfnos.longitud() != 0)
							flujoS.println("bsqueda fallida");
						else
							flujoS.println("lista vaca");
					else
					{
						flujoS.println("Nmero de registro: " + pos);
						flujoS.println(listatfnos.valorEn(pos).obtenerNombre());
						flujoS.println(listatfnos.valorEn(pos).obtenerDireccin());
						flujoS.println(listatfnos.valorEn(pos).obtenerTelfono());
					}
					break;
				case 3: // modificar
					// Solicitar el nmero de registro a modificar  
					flujoS.print("nmero de registro entre 0 y " + 
							(listatfnos.longitud() - 1) + ": ");
					pos = Leer.datoInt();
					modificado = modificar(pos);
					if (modificado)
						flujoS.println("modificacin realizada con xito");
					else
						flujoS.println("error: no se modific el registro");
					break;
				case 4: // aadir
					flujoS.print("nombre:    "); nombre = Leer.dato();
					flujoS.print("direccin: "); direccin = Leer.dato();
					flujoS.print("telfono:  "); telfono = Leer.datoLong();
					listatfnos.aadir(new CPersona(nombre, direccin, telfono));
					break;
				case 5: // eliminar
					flujoS.print("telfono: "); telfono = Leer.datoLong();
					eliminado = listatfnos.eliminar(telfono);
					if (eliminado)
						flujoS.println("registro eliminado");
					else
						if (listatfnos.longitud() != 0)
							flujoS.println("telfono no encontrado");
						else
							flujoS.println("lista vaca");
					break;
				case 6: // imprimir
					imprimirListaTfnos();
					break;
				case 7: // salir
					// guardar lista
					if (eliminado) actualizar(fichero);
					listatfnos = null;
				}
			}
			while(opcin != 7);
		}
		catch (IOException e)
		{
			flujoS.println("Error: " + e.getMessage());
		}
	}
}
