package itz;
/////////////////////////////////////////////////////////////////
//Definicin de la clase CListaTfnos.
//
import java.io.*;
public class CListaTfnos
{
	private RandomAccessFile fes; // flujo
	private int nregs;           // nmero de registros
	private int tamaoReg = 140; // tamao del registro en bytes

	public CListaTfnos(File fichero) throws IOException
	{
		if (fichero.exists() && !fichero.isFile())
			throw new IOException(fichero.getName() + " no es un fichero");
		fes = new RandomAccessFile(fichero, "rw");
		// Como es casi seguro que el ltimo registro no ocupe el
		// tamao fijado, utilizamos ceil para redondear por encima.
		nregs = (int)Math.ceil((double)fes.length() / (double)tamaoReg);
	}

	public void cerrar() throws IOException { fes.close(); }

	public int longitud() { return nregs; } // nmero de registros

	public boolean ponerValorEn( int i, CPersona objeto ) throws IOException
	{
		if (i >= 0 && i <= nregs)
		{
			if (objeto.tamao() + 4 > tamaoReg)
				System.err.println("tamao del registro excedido");
			else
			{
				fes.seek(i * tamaoReg); // situar el puntero de L/E
				fes.writeUTF(objeto.obtenerNombre());
				fes.writeUTF(objeto.obtenerDireccin());
				fes.writeLong(objeto.obtenerTelfono());
				return true;
			}
		}
		else
			System.err.println("nmero de registro fuera de lmites");
		return false;
	}

	public CPersona valorEn( int i ) throws IOException
	{
		if (i >= 0 && i < nregs)
		{
			fes.seek(i * tamaoReg); // situar el puntero de L/E

			String nombre, direccin;
			long telfono;
			nombre = fes.readUTF();
			direccin = fes.readUTF();
			telfono = fes.readLong();

			return new CPersona(nombre, direccin, telfono);
		}
		else
		{
			System.out.println("nmero de registro fuera de lmites");
			return null;
		}
	}

	public void aadir(CPersona obj) throws IOException
	{
		if (ponerValorEn( nregs, obj )) nregs++;
	}

	public boolean eliminar(long tel) throws IOException
	{
		CPersona obj;
		// Buscar el telfono y marcar el registro para
		// posteriormente eliminarlo
		for ( int reg_i = 0; reg_i < nregs; reg_i++ )
		{
			obj = valorEn(reg_i);
			if (obj.obtenerTelfono() == tel)
			{
				obj.asignarTelfono(0); //Marcar para eliminar
				ponerValorEn( reg_i, obj );
				return true;
			}
		}
		return false;
	}

	public int buscar(String str, int pos) throws IOException
	{
		// Buscar un registro por una subcadena del nombre
		// a partir de un registro determinado
		CPersona obj;
		String nom;
		if (str == null) return -1;
		if (pos < 0) pos = 0;
		for ( int reg_i = pos; reg_i < nregs; reg_i++ )
		{
			obj = valorEn(reg_i);
			nom = obj.obtenerNombre();
			// str est contenida en nom?
			if (nom.indexOf(str) > -1)
				return reg_i;
		}
		return -1;
	}
}

