package Vista;

import java.awt.BorderLayout;
import java.awt.EventQueue;

import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.border.EmptyBorder;
import javax.swing.JMenuBar;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import java.awt.event.ActionListener;
import java.io.*;
import java.awt.event.ActionEvent;
import javax.swing.*;
import java.awt.Color;
import Modelo.*;
public class Hospital extends JFrame {
	    JDesktopPane principal;
	    ListaPaciente lstPacientes=new ListaPaciente();
	
	public static void main(String[] args) {
		EventQueue.invokeLater(new Runnable() {
			public void run() {
				try {
					Hospital frame = new Hospital();
					frame.setVisible(true);
				} catch (Exception e) {
					e.printStackTrace();
				}
			}
		});
	}

	/**
	 * Create the frame.
	 */
	public Hospital() {
		setTitle("HOSPITAL SAN JOSE");
		setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
		setBounds(10, 10, 800, 600);
		principal=new JDesktopPane();
		principal.setBackground(Color.LIGHT_GRAY);
		setContentPane(principal);
		
		JMenuBar menuBar = new JMenuBar();
		setJMenuBar(menuBar);
		
		JMenu mnArchivo = new JMenu("Archivo");
		menuBar.add(mnArchivo);
		
		JMenuItem mntmGuardar = new JMenuItem("Guardar");
		mntmGuardar.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent e) {
				try{
				JFileChooser dialogo=new JFileChooser();
				if (dialogo.showSaveDialog(principal)==JFileChooser.APPROVE_OPTION) {
				      File archivo =dialogo.getSelectedFile();	
				      if  (archivo!=null){
				    	  FileOutputStream fos=new FileOutputStream(archivo);
				    	  ObjectOutputStream oos=new ObjectOutputStream(fos);
				    	  //Escribe cada objeto paciente en el archivo
				    	  for (Paciente p:lstPacientes.pacientes){
				    		  oos.writeObject(p);
				    	  }
				    	  fos.close();
				    	  JOptionPane.showMessageDialog(principal,"Archivo Guardado con Exito");
				      }
				}
				} catch (Exception ex){
					JOptionPane.showMessageDialog(principal,"Error al guardar archivo");
				}
			}
		});
		mnArchivo.add(mntmGuardar);
		
		JMenuItem mntmAbrir = new JMenuItem("Abrir");
		mntmAbrir.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent e) {
				FileInputStream fis=null;
				try{
					JFileChooser dialogo=new JFileChooser();
					if (dialogo.showOpenDialog(principal)==JFileChooser.APPROVE_OPTION) {
					      File archivo =dialogo.getSelectedFile();	
					      if  (archivo!=null){
					    	   fis=new FileInputStream(archivo);
					    	  ObjectInputStream ois=new ObjectInputStream(fis);
					    	  lstPacientes.pacientes.clear();//Borra todos los elemtos de la lista
					    	  //Lee cada objeto del archivo y lo escribe en la lista de pacientes
					    	  Paciente p;
					    	  while (true){
					    		   p=(Paciente) ois.readObject();
					    		   lstPacientes.pacientes.add(p);
					    	  }
					      }
					}
					} catch (EOFException ex){
						try {
							fis.close();
							JOptionPane.showMessageDialog(principal,"Datos Cargados con Exito");
						} catch (IOException e1) {
							e1.printStackTrace();
						}
					}
				catch (Exception ex){
						JOptionPane.showMessageDialog(principal,"Error al abrir archivo");
					}
			}
		});
		mnArchivo.add(mntmAbrir);
		
		JMenu mnPersonal = new JMenu("Personal");
		menuBar.add(mnPersonal);
		
		JMenu mnPacientes = new JMenu("Pacientes");
		mnPersonal.add(mnPacientes);
		
		JMenuItem mntmAlta = new JMenuItem("Alta");
		Hospital h=this; //Obtiene el contexto actual
		mntmAlta.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent arg0) {
				AltaPaciente ventanaInterna=new AltaPaciente("Alta de Usuario",true,true,true,h);
				principal.add(ventanaInterna);
			}
		});
		mnPacientes.add(mntmAlta);
		
		JMenuItem mntmBajas = new JMenuItem("Bajas");
		mnPacientes.add(mntmBajas);
		
		JMenuItem mntmConsultas = new JMenuItem("Mostrar");
		mntmConsultas.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent arg0) {
				MostrarPacientes ventanaMostrar=new MostrarPacientes(h);
				principal.add(ventanaMostrar);
			}
		});
		mnPacientes.add(mntmConsultas);
		}
}
