package Vista;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;

import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JInternalFrame;
import javax.swing.JPanel;
import javax.swing.border.EmptyBorder;

import Modelo.Paciente;

import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JTextField;
import javax.swing.JComboBox;
import javax.swing.JDesktopPane;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JRadioButton;
import java.awt.event.ActionListener;
import java.awt.event.ActionEvent;

public class AltaPaciente extends JInternalFrame implements ActionListener
{
	//Obtener el contexto del Frame principal Hospital
	private Hospital principal;
	private Paciente pacientex=null;
	private JPanel contentPanel;
	private JTextField txtNombre;
	private JTextField txtEdad;
	private JTextField txtNoOpera;
	private JButton btnAceptar;
	private JButton btnCancelar;
	private JRadioButton rdbtnFemenino,rdbtnMasculino;
	private JComboBox<String> cbEdoCivil;
	
	public AltaPaciente(String titulo, boolean tamao, 
			boolean cerrar, boolean maximizar,
			Hospital padre) {
		super(titulo, tamao,cerrar, maximizar);
		principal=padre;
		contentPanel=(JPanel) this.getContentPane();
		contentPanel.setLayout(null);
		JLabel lblNombre = new JLabel("Nombre:");
		lblNombre.setBounds(20, 11, 60, 14);
		contentPanel.add(lblNombre);
		
		txtNombre = new JTextField();
		txtNombre.setBounds(85, 8, 284, 20);
		contentPanel.add(txtNombre);
		txtNombre.setColumns(10);
		{
			JLabel lblEdad = new JLabel("Edad:");
			lblEdad.setBounds(20, 39, 46, 14);
			contentPanel.add(lblEdad);
		}
		{
			txtEdad = new JTextField();
			txtEdad.setColumns(10);
			txtEdad.setBounds(85, 36, 46, 20);
			contentPanel.add(txtEdad);
		}
		{
			JLabel lblSexo = new JLabel("Sexo:");
			lblSexo.setBounds(20, 67, 46, 14);
			contentPanel.add(lblSexo);
		}
		{
			JLabel lblEstadoCivil = new JLabel("Estado Civil:");
			lblEstadoCivil.setBounds(10, 95, 73, 14);
			contentPanel.add(lblEstadoCivil);
		}
		{
			JLabel lblNoOperaciones = new JLabel("No. Operaciones:");
			lblNoOperaciones.setBounds(10, 123, 101, 14);
			contentPanel.add(lblNoOperaciones);
		}
		{
			txtNoOpera = new JTextField();
			txtNoOpera.setColumns(10);
			txtNoOpera.setBounds(114, 120, 37, 20);
			contentPanel.add(txtNoOpera);
		}
		
		cbEdoCivil = new JComboBox<String>();
		cbEdoCivil.setModel(new DefaultComboBoxModel<String>(new String[] {"Soltero", "Casado", "Viudo", "Divorciado", "Union Libre"}));
		cbEdoCivil.setBounds(85, 95, 188, 20);
		contentPanel.add(cbEdoCivil);
		ButtonGroup sexo=new ButtonGroup();
		rdbtnMasculino = new JRadioButton("Masculino");
		rdbtnMasculino.setBounds(75, 63, 85, 23);
		sexo.add(rdbtnMasculino);
		contentPanel.add(rdbtnMasculino);
		
		rdbtnFemenino = new JRadioButton("Femenino");
		rdbtnFemenino.setBounds(176, 63, 85, 23);
		rdbtnFemenino.setSelected(true);
		sexo.add(rdbtnFemenino);
		contentPanel.add(rdbtnFemenino);
		
		btnAceptar = new JButton("Aceptar");
		btnAceptar.setBounds(95, 163, 89, 23);
		btnAceptar.addActionListener(this);
		getContentPane().add(btnAceptar);
		
		btnCancelar = new JButton("Cancelar");
		btnCancelar.setBounds(195, 163, 89, 23);
		btnCancelar.addActionListener(this);
		getContentPane().add(btnCancelar);
		
		setBounds(100,100,489,275);
		setVisible(true);
	}

	@Override
	public void actionPerformed(ActionEvent e) {
		if (e.getSource()==btnAceptar){
			try {
			   String nombrex=txtNombre.getText();
			   int edadx=Integer.parseInt(txtEdad.getText());
			   char sexox='M';
			  if (rdbtnMasculino.isSelected()) sexox='M';
			  if (rdbtnFemenino.isSelected()) sexox='F';
			  String edoCivilx=cbEdoCivil.getItemAt(cbEdoCivil.getSelectedIndex());
			  int operax=Integer.parseInt(txtNoOpera.getText());
			  pacientex=new Paciente(nombrex,edadx, sexox,edoCivilx, operax);
			  principal.lstPacientes.altaPaciente(pacientex);
			  this.dispose();
			} catch (Exception ex){
				ex.printStackTrace();
				JOptionPane.showMessageDialog(null,"Datos incorrectos");
			}
		}
		if (e.getSource()==btnCancelar) {pacientex=null;this.dispose();}
	}
}
