package Modelo;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.Scanner;
public class Paciente implements Serializable //Para que se pueda guardar el objeto en un archivo
{
	//Atributos
	private String nombre;
	private int edad;
	private char sexo; //M o F
	private String edoCivil;
	private int numOperaciones;
	private int numConsultas;
	private ArrayList<Consulta> expediente; //Arreglo para almacenar objetos de tipo consulta
	public int getEdad() {
		return edad;
	}

	public char getSexo() {
		return sexo;
	}

	public String getEdoCivil() {
		return edoCivil;
	}

	public int getNumOperaciones() {
		return numOperaciones;
	}
	//Constructores
	public Paciente() {
		super();
		this.numConsultas=0;
		this.expediente=new ArrayList<Consulta>();
	}

	public Paciente(String nombre, int edad, char sexo, String edoCivil, int numOperaciones) {
		this(); //Constructor por defecto
		this.nombre = nombre;
		this.edad = edad;
		this.sexo = sexo;
		this.edoCivil = edoCivil;
		this.numOperaciones = numOperaciones;
	}
	//Metodo para pedir y llenar los datos correspondientes a una instancia
	public void pedirDatos(){
		  Scanner leer=new Scanner(System.in);
		  System.out.print("Nombre:");this.nombre=leer.nextLine();
		  System.out.print("Edad:");this.edad=leer.nextInt();leer.nextLine();
		  System.out.print("Sexo:");this.sexo=leer.nextLine().charAt(0);
		  System.out.print("Estado civil");this.edoCivil=leer.nextLine();
		  System.out.print("No. Operaciones Quirurgicas");this.numOperaciones=leer.nextInt();
		  leer.nextLine();
	}
   //Metodo para escribir los datos de un paciente
	public String obtDatos() {
		return "nombre=" + nombre + " \nedad=" + edad + "\n sexo=" + sexo + "\n edoCivil=" + edoCivil
				+ "\n numOperaciones=" + numOperaciones + "\n numConsultas=" + numConsultas;
	}
	//Metodo para dar de alta una consulta en el arreglo expediente
	public void altaConsulta(Consulta consultax){
		expediente.add(consultax);this.numConsultas++;
	}
	//Metodos sobrecargados para recorrer y listar las consultas que tiene un paciente
	public void listarConsulta(){
		System.out.println("Historial Medico:");
		for (int i=0;i<numConsultas;i++)
			System.out.println(expediente.get(i));
	}
	public void listarConsulta(Date fechax){
		System.out.println("Historial Medico:");
		for (Consulta c:expediente){
			if (c.getFecha().equals(fechax)) System.out.println(c);
		}
	}
	public void listarConsulta(int n){
     if (n<=numConsultas){		
		System.out.println("Historial Medico:");
		for (int i=numConsultas-1;i>=(numConsultas-n);i--)
			System.out.println(expediente.get(i));
     } else System.out.println("No tiene tantas consultas");
	}
	//Metodo get para poder acceder al nombre y hacer busquedas 
	public String getNombre() {
		return nombre;
	}
}
