package itz;
import java.io.Serializable;
public class Amigo implements Serializable {
	//Atributos
	private long telefono;
	private String nombre;
	private String direccion;
	//Constructores
	public Amigo(String nombre) {
		super();
		this.nombre = nombre;
	}
	public Amigo(long telefono, String nombre, String direccion) {
		super();
		this.telefono = telefono;
		this.nombre = nombre;
		this.direccion = direccion;
	}
	//Metodos getters y setters
	public long getTelefono() {
		return telefono;
	}
	public void setTelefono(long telefono) {
		this.telefono = telefono;
	}
	public String getNombre() {
		return nombre;
	}
	public void setNombre(String nombre) {
		this.nombre = nombre;
	}
	public String getDireccion() {
		return direccion;
	}
	public void setDireccion(String direccion) {
		this.direccion = direccion;
	}
	//Redefinicion o sobrescritura de metodos
	@Override
	public String toString() {
		return "Amigo [telefono=" + telefono + ", nombre=" + nombre + ", direccion=" + direccion + "]";
	}
	@Override //Para buscar a un amigo por nombre en una lista
	public boolean equals(Object otro) {
		if (otro instanceof Amigo) {
			Amigo otroAmigo=(Amigo) otro; //Conversin explicita (Case)
			return this.nombre.equalsIgnoreCase(otroAmigo.nombre);
		} else return false;
	}
}
