package itz;
import java.awt.event.*;
import java.awt.*;
import javax.swing.*;
import java.io.*;
import java.util.*;
public class AgendaAmigos extends JFrame implements ActionListener {
    //Atributos componentes graficos
	private JPanel principal;
	private JTextField txtTel;
	private JTextField txtNombre;
	private JTextField txtDir;
	private ArrayList<Amigo> listaAmigos=new ArrayList<Amigo>();
	private int posicion; //Variable auxiliar para navegacion en la lista
	private JButton btnAgregar,btnEliminar,btnModificar;
	private JButton btnPrimero,btnUltimo,btnAnterior,btnSiguiente;
	private JPanel panelNavega,panelAcepta;
	private JButton btnAceptar,btnCancelar;
	private JMenuItem mntmGuardar,mntmAbrir;
	
	//Constructor
	public AgendaAmigos() {
		setTitle("Agenda de Amigos");
		setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
		setBounds(100,100,587,362);
		//Componentes de menu
		JMenuBar menuBar=new JMenuBar();
		setJMenuBar(menuBar);
		JMenu mnArchivo=new JMenu("Archivo");
		menuBar.add(mnArchivo);
		mntmGuardar=new JMenuItem("Guardar");
		mnArchivo.add(mntmGuardar);
		mntmAbrir=new JMenuItem("Abrir");
		mnArchivo.add(mntmAbrir);
		//Obtener el panel contenedor del JFrame
		principal=(JPanel) this.getContentPane();
		principal.setBackground(Color.LIGHT_GRAY);
		principal.setLayout(null);
		
		//Componentes basicos
		JLabel lblTel=new JLabel("Telefono:");
		lblTel.setBounds(12,55,84,14);
		principal.add(lblTel);
		
		JLabel lblNombre=new JLabel("Nombre:");
		lblNombre.setBounds(12,97,84,14);
		principal.add(lblNombre);
		
		JLabel lblDir=new JLabel("Direccion:");
		lblDir.setBounds(12,141,84,14);
		principal.add(lblDir);
		
		txtTel=new JTextField(10);
		txtTel.setBounds(106, 52,130,20);
		principal.add(txtTel);
		
		txtNombre=new JTextField(30);
		txtNombre.setBounds(106, 94,297,20);
		principal.add(txtNombre);
		
		txtDir=new JTextField(30);
		txtDir.setBounds(106, 141,297,20);
		principal.add(txtDir);
		
		//Crear botones
		btnAgregar=new JButton("Agregar");
		btnAgregar.setBounds(439,51,89,23);
		principal.add(btnAgregar);
		
		btnEliminar=new JButton("Eliminar");
		btnEliminar.setBounds(439,93,89,23);
		btnEliminar.setEnabled(false);
		principal.add(btnEliminar);
		
		btnModificar=new JButton("Modificar");
		btnModificar.setBounds(439,137,89,23);
		btnModificar.setEnabled(false);
		principal.add(btnModificar);
		
		//Creo paneles auxiliares
		panelAcepta=new JPanel();
		panelAcepta.setBounds(151,182,252,43);
		panelAcepta.setVisible(false);
		panelAcepta.setLayout(null);
		principal.add(panelAcepta);
		
		btnAceptar=new JButton("Aceptar");
		btnAceptar.setBounds(24,11,89,23);
		panelAcepta.add(btnAceptar);
		
		btnCancelar=new JButton("Cancelar");
		btnCancelar.setBounds(140,11,89,23);
		panelAcepta.add(btnCancelar);
		
		panelNavega=new JPanel();
		panelNavega.setBounds(73,248,406,42);
		panelNavega.setVisible(false);
		panelNavega.setLayout(null);
		principal.add(panelNavega);
		
		btnPrimero=new JButton("Primero");
		btnPrimero.setBounds(10,11,89,23);
		panelNavega.add(btnPrimero);
		
		btnAnterior=new JButton("Anterior");
		btnAnterior.setBounds(106,11,89,23);
		panelNavega.add(btnAnterior);
		
		btnSiguiente=new JButton("Siguiente");
		btnSiguiente.setBounds(205,11,89,23);
		panelNavega.add(btnSiguiente);
		
		btnUltimo=new JButton("Ultimo");
		btnUltimo.setBounds(304,11,89,23);
		panelNavega.add(btnUltimo);
		
		//Agregar acciones a los botones
		btnAgregar.addActionListener(this);
		btnEliminar.addActionListener(this);
		btnModificar.addActionListener(this);
		btnAceptar.addActionListener(this);
		btnCancelar.addActionListener(this);
		btnPrimero.addActionListener(this);
		btnAnterior.addActionListener(this);
		btnSiguiente.addActionListener(this);
		btnUltimo.addActionListener(this);
		mntmGuardar.addActionListener(this);
		mntmAbrir.addActionListener(this);
	
		setVisible(true);
	}

	private void limpiarTexto() {
		txtTel.setText("");
		txtNombre.setText("");
		txtDir.setText("");
		txtTel.requestFocus();
	}
	
	@Override
	public void actionPerformed(ActionEvent evento) {
		String accion=evento.getActionCommand();
		switch (accion) {
		case "Agregar":limpiarTexto();
		btnAgregar.setEnabled(false);
		btnEliminar.setEnabled(false);
		btnModificar.setEnabled(false);
		panelAcepta.setVisible(true);
		panelNavega.setVisible(false);
		break;
		case "Aceptar":
			try {
				long tel=Long.parseLong(txtTel.getText());
				String nom=txtNombre.getText();
				String dir=txtDir.getText();
				//Crear un objeto de tipo amigo
				Amigo amigox=new Amigo(tel,nom,dir);
				//Agreagr a la lista de amigos (ArrayList)
				listaAmigos.add(amigox);
				posicion=listaAmigos.size()-1;
				panelAcepta.setVisible(false);
				panelNavega.setVisible(true);
				//Activar botones
				btnAgregar.setEnabled(true);
				btnEliminar.setEnabled(true);
				btnModificar.setEnabled(true);
				JOptionPane.showMessageDialog(null, "Amigo Agregado");
			} catch (Exception ex) {
				JOptionPane.showMessageDialog(null, "Datos Incorrectos");
			}
			break;
		case "Cancelar":
			if (listaAmigos.size()>=1) {
				Amigo amigox=listaAmigos.get(posicion);
				txtTel.setText(""+amigox.getTelefono());
				txtNombre.setText(amigox.getNombre());
				txtDir.setText(amigox.getDireccion());
				panelAcepta.setVisible(false);
				panelNavega.setVisible(true);
				//Activar botones
				btnAgregar.setEnabled(true);
				btnEliminar.setEnabled(true);
				btnModificar.setEnabled(true);
			} else {
				//DesActivar botones
				btnAgregar.setEnabled(true);
				btnEliminar.setEnabled(false);
				btnModificar.setEnabled(false);
				panelNavega.setVisible(false);
			}
			break;
		case "Primero":
			if (listaAmigos.size()>=1) {
				posicion=0;
				Amigo amigox=listaAmigos.get(posicion);
				txtTel.setText(""+amigox.getTelefono());
				txtNombre.setText(amigox.getNombre());
				txtDir.setText(amigox.getDireccion());
			} else JOptionPane.showMessageDialog(null, "Lista Vacia");
			break;
		case "Ultimo":
			if (listaAmigos.size()>=1) {
				posicion=listaAmigos.size()-1;
				Amigo amigox=listaAmigos.get(posicion);
				txtTel.setText(""+amigox.getTelefono());
				txtNombre.setText(amigox.getNombre());
				txtDir.setText(amigox.getDireccion());
			} else JOptionPane.showMessageDialog(null, "Lista Vacia");
			break;
		case "Anterior":
			if (listaAmigos.size()>=1) {
				if (posicion>0) {
					posicion=posicion-1;
					Amigo amigox=listaAmigos.get(posicion);
					txtTel.setText(""+amigox.getTelefono());
					txtNombre.setText(amigox.getNombre());
					txtDir.setText(amigox.getDireccion());
				}
			} else JOptionPane.showMessageDialog(null, "Lista Vacia");
			break;
		case "Siguiente":
			if (listaAmigos.size()>=1) {
				if (posicion<(listaAmigos.size()-1)) {
					posicion=posicion+1;
					Amigo amigox=listaAmigos.get(posicion);
					txtTel.setText(""+amigox.getTelefono());
					txtNombre.setText(amigox.getNombre());
					txtDir.setText(amigox.getDireccion());
				}
			} else JOptionPane.showMessageDialog(null, "Lista Vacia");
			break;
		case "Eliminar":
			if (listaAmigos.size()>=1) {
				listaAmigos.remove(posicion);
				posicion=listaAmigos.size()-1; //Lo manda al ultimo amigo
				if (posicion>=0) {
					Amigo amigox=listaAmigos.get(posicion);
					txtTel.setText(""+amigox.getTelefono());
					txtNombre.setText(amigox.getNombre());
					txtDir.setText(amigox.getDireccion());
				} else { //La lista quedo vacia
					limpiarTexto();
					btnAgregar.setEnabled(true);
					btnEliminar.setEnabled(false);
					btnModificar.setEnabled(false);
					panelNavega.setVisible(false);
					panelAcepta.setVisible(false);
					btnAgregar.requestFocus();
				}			
			} else JOptionPane.showMessageDialog(null, "Lista Vacia");
			break;
		case "Modificar":
			if (listaAmigos.size()>=1) {
				try {
					long tel=Long.parseLong(txtTel.getText());
					String nom=txtNombre.getText();
					String dir=txtDir.getText();
					//Crear un objeto de tipo amigo
					Amigo amigox=new Amigo(tel,nom,dir);
					//Modificar el objeto amigo en la lista
					listaAmigos.set(posicion, amigox);
					JOptionPane.showMessageDialog(null, "Amigo Modificado");
				} catch (Exception ex) {
					JOptionPane.showMessageDialog(null, "Datos Incorrectos");
				}
			} else JOptionPane.showMessageDialog(null, "Lista Vacia");
			break;
		//Opciones para Crear y abrir archivo de objetos
		case "Guardar":
			try {
				FileOutputStream archivo=new FileOutputStream("amigos.obj");
				ObjectOutputStream escribir=new ObjectOutputStream(archivo);
				for (Amigo amigox:listaAmigos) {
					escribir.writeObject(amigox);
				}
				escribir.close(); //Se cierra el buffer no el archivo
				JOptionPane.showMessageDialog(null,"Datos almacenados");
			} catch (IOException ex) {
				JOptionPane.showMessageDialog(null,"Error al Guardar");
			};
			break;
		case "Abrir":
			ObjectInputStream leer=null;
			try {
				FileInputStream archivo=new FileInputStream("amigos.obj");
				leer=new ObjectInputStream(archivo);
				listaAmigos.clear();
				long tel;String nom,dir;Amigo amigox;
				while (true) {
					amigox=(Amigo) leer.readObject();
					listaAmigos.add(amigox);
				}
			} catch (EOFException fin) {
				if (leer!=null) {
					try {
						leer.close();
						//Activar panel de navegacion
						panelNavega.setVisible(true);
						//Activar botones
						btnAgregar.setEnabled(true);
						btnEliminar.setEnabled(true);
						btnModificar.setEnabled(true);
						if (listaAmigos.size()>=1){
							posicion=0;
							Amigo amigox=listaAmigos.get(posicion);
							txtTel.setText(""+amigox.getTelefono());
							txtNombre.setText(amigox.getNombre());
							txtDir.setText(amigox.getDireccion());
						} else JOptionPane.showMessageDialog(null,"Lista vacia");
					} catch (IOException e3) {
						e3.printStackTrace();
					} 
					JOptionPane.showMessageDialog(null,"Datos Recuperados");
				}
			} catch (Exception ex) {
				JOptionPane.showMessageDialog(null,"Error al Abrir");
			}	
		}
	}
	
	public static void main(String args[]) {
		AgendaAmigos agenda=new AgendaAmigos();
	}
}
