package itz; 
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.Scanner;

public class AccesoRandom{

    public static void main(String[] args) {
        Scanner sc = new Scanner(System.in);
        RandomAccessFile archivo = null;
        int pos, numero;
        long size;
        try {
            archivo = new RandomAccessFile("enteros.dat", "rw");

            //calcular cuntos enteros tiene el archivo
            size = archivo.length();
            size = size / 4;
            System.out.println("El archivo tiene " + size + " enteros");

            //Modificar el entero que se encuentra en una posicin determinada
            do {
                System.out.println("Introduce una posicin (>=1 y <= " + size + "): ");
                pos = sc.nextInt();
            } while (pos < 1 || pos > size);

            pos--;  //la posicin 1 realmente es la 0
           
            //nos situamos en la posicin (byte de inicio) del entero a modificar
            //en Java un entero ocupa 4 bytes
            archivo.seek(pos*4);

            //leemos y mostramos el valor actual
            System.out.println("Valor actual: " + archivo.readInt());
           
            //pedimos que se introduzca el nuevo valor
            System.out.println("Introduce nuevo valor: ");
            numero = sc.nextInt();

            //nos situamos de nuevo en la posicin del entero a modificar
            //esto es necesario porque despus de la lectura que hemos realizado para mostrar
            //el valor el puntero de lectura/escritura ha avanzado al siguiente entero del archivo.
            //si no hacemos esto escribiremos sobre el siguiente entero
            archivo.seek(pos*4);

            //escribimos el entero
            archivo.writeInt(numero);

        } catch (FileNotFoundException ex) {
            System.out.println(ex.getMessage());
        } catch (IOException ex) {
            System.out.println(ex.getMessage());
        }finally {
            try {
                if (archivo != null) {
                    archivo.close();
                    System.out.println("Operacion exitosa");
                }
            } catch (IOException e) {
                System.out.println(e.getMessage());
            }
        }
    }
}
