package itz.archivos;
//Clase que implemente las operaciones de 
//Lectura y escritura en archivos de texto
import java.io.*; //Conjunto de clases para manejo de archivos
import static javax.swing.JOptionPane.*;
public class OperacionesArchivos {
	//Operacion de Lectura
	public String leerArchivo(String nomarch) {
		FileReader archivo=null;
		BufferedReader leer=null;
		//Se usa para almacenar temporalmente las lineas de texto extraidas del archivo
		String salida=""; 
		try {
			archivo=new FileReader(nomarch);
			leer=new BufferedReader(archivo); //Optimizar accesos a Disco
			String linea;
			do {
				linea=leer.readLine(); //Lee una linea de texto del archivo
				if (linea!=null) salida+=linea+"\n";
			} while (linea!=null);
			
		} catch (IOException ex) {
			showMessageDialog(null,"Error al abrir archivo");
		} finally {
			try {
				leer.close();
			} catch (Exception e) {
				showMessageDialog(null,"Error al cerrar archivo");
			}
		}
		return salida;
	}
	//Operacin de escritura de archivos de texto
	public void escribiArchivo(String nomarch,String entrada,boolean agregar) {
		FileWriter archivo=null;
		BufferedWriter escribir=null;
		try {
			//Parametro agregar sirve para indicar si se agrega el nuevo texto
			//al final del archivo o si se sobreescribe
			archivo=new FileWriter(nomarch,agregar);
			escribir=new BufferedWriter(archivo);
			if (agregar) escribir.append(entrada);
			else escribir.write(entrada);
			showMessageDialog(null,"Ya se guardo el archivo");
		} catch (IOException ex) {
			showMessageDialog(null,"Error al escribir archivo");
		}  finally {
			try {
				escribir.close();
			} catch (Exception e) {
				showMessageDialog(null,"Error al cerrar archivo");
			}
		}
	}
}
