package itz.archivos;

import java.awt.BorderLayout;
import java.awt.EventQueue;

import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.border.EmptyBorder;
import javax.swing.filechooser.FileNameExtensionFilter;
import javax.swing.JTextArea;
import javax.swing.JScrollPane;
import javax.swing.JMenuBar;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JLabel;
import java.awt.Font;
import javax.swing.JTextField;
import javax.swing.JButton;
import javax.swing.JFileChooser;

import java.awt.event.ActionListener;
import java.awt.event.ActionEvent;

public class InterfazArchivoTexto extends JFrame {

	private JPanel contentPane;
	private JTextField txtNombre;

	/**
	 * Launch the application.
	 */
	public static void main(String[] args) {
		EventQueue.invokeLater(new Runnable() {
			public void run() {
				try {
					InterfazArchivoTexto frame = new InterfazArchivoTexto();
					frame.setVisible(true);
				} catch (Exception e) {
					e.printStackTrace();
				}
			}
		});
	}

	/**
	 * Create the frame.
	 */
	public InterfazArchivoTexto() {
		setTitle("Archivos de Texto");
		setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
		setBounds(100, 100, 903, 611);
		
		JMenuBar menuBar = new JMenuBar();
		setJMenuBar(menuBar);
		
		JMenu mnArchivo = new JMenu("Archivo");
		menuBar.add(mnArchivo);
		
		JMenuItem mntmAbrir = new JMenuItem("Abrir");
		
		mnArchivo.add(mntmAbrir);
		
		JMenuItem mntmGuardar = new JMenuItem("Guardar");
		
		mnArchivo.add(mntmGuardar);
		
		JMenu mnSalir = new JMenu("Salir");
		
		menuBar.add(mnSalir);
		contentPane = new JPanel();
		contentPane.setBorder(new EmptyBorder(5, 5, 5, 5));
		setContentPane(contentPane);
		contentPane.setLayout(null);
		
		JScrollPane scrollPane = new JScrollPane();
		scrollPane.setBounds(12, 132, 862, 396);
		contentPane.add(scrollPane);
		
		JTextArea txtSalida = new JTextArea();
		scrollPane.setViewportView(txtSalida);
		txtSalida.setText("");
		
		JLabel lblRutaYNombre = new JLabel("Ruta y Nombre del Archivo:");
		lblRutaYNombre.setFont(new Font("Arial Black", Font.BOLD, 17));
		lblRutaYNombre.setBounds(12, 13, 290, 36);
		contentPane.add(lblRutaYNombre);
		
		txtNombre = new JTextField();
		txtNombre.setFont(new Font("Tahoma", Font.PLAIN, 15));
		txtNombre.setBounds(12, 64, 708, 36);
		contentPane.add(txtNombre);
		txtNombre.setColumns(100);
		
		JButton btnExaminar = new JButton("Examinar...");
		
		btnExaminar.setFont(new Font("Tahoma", Font.PLAIN, 17));
		btnExaminar.setBounds(742, 60, 132, 41);
		contentPane.add(btnExaminar);
		//Poner todo el control de eventos y acciones despues de la creacion de componentes
		mntmAbrir.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent arg0) {
				OperacionesArchivos archivos=new OperacionesArchivos();
				txtSalida.setText(archivos.leerArchivo(txtNombre.getText()));
			}
		});
		mntmGuardar.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent e) {
				OperacionesArchivos archivos=new OperacionesArchivos();
				archivos.escribiArchivo(txtNombre.getText(),txtSalida.getText(), false);
			}
		});
		mnSalir.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent e) {
				System.exit(0);
			}
		});
		btnExaminar.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent e) {
				JFileChooser chooser=new JFileChooser();
				FileNameExtensionFilter filter=new FileNameExtensionFilter("TXT TEXTO","txt");
				chooser.setFileFilter(filter);
				int opcion=chooser.showSaveDialog(null);
				if (opcion==JFileChooser.APPROVE_OPTION) {
					txtNombre.setText(chooser.getSelectedFile().getAbsolutePath());
				}
			}
		});
	}
}
